llmApp.directive('columnMappings', ['PythonService', '$timeout','PLUGIN_PATHS', function (PythonService, $timeout,PLUGIN_PATHS) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'column-mappings-template.html',
        scope: {
            config: '=',
            formName: '=', // For validation
            datasets: '<', // One-way binding: The dataset(s) selected that determine available columns
            isRequired: '@?', // Optional: 'true' if the whole block/each mapping is required,
            configProperty: '@?',
            context: '@' // Optional: Context for backend call
        },
        link: function (scope) {
            scope.isRequired = scope.isRequired === 'true';
            scope.showDeleteTooltip = {};



            // Initialize columnMaps from config or as an empty array
            scope.config[scope.configProperty] = scope.config[scope.configProperty] || [];
            scope.columnMaps = scope.config[scope.configProperty];


            scope.availableColumns = []; // This will hold the {value, label} objects from the backend

            // Function to fetch columns from backend
            scope.fetchColumns = function () {
                // Clear existing columns and selections immediately to avoid stale data
                scope.availableColumns = [];


                if (!scope.datasets || (Array.isArray(scope.datasets) && scope.datasets.length === 0)) {

                    scope.columnMaps = []; // Clear existing column mappings if no datasets are provided
                    return; // Don't call API if no datasets selected
                }


                PythonService.callPythonDo({
                    parameterName: 'columns_mappings',
                    sql_retrieval_table_list: scope.datasets
                }).then(function (data) {
                    if (data && Array.isArray(data.choices)) {
                        $timeout(function() {
                            scope.availableColumns = data.choices;

                        }, 0);

                    } else {

                        scope.availableColumns = [];
                    }
                }, function (error) {

                    scope.availableColumns = [];
                });
            };

            // Watch for changes in the 'datasets' property
            scope.$watch('datasets', function (newVal, oldVal) {
                // Check for value equality to avoid unnecessary calls if new and old are same
                if (angular.equals(newVal, oldVal)) {
                    return;
                }
                scope.fetchColumns();
            }, true); // `true` for objectEquality if datasets is an array/object

            // Function to add a new column mapping object
            scope.addColumnMapping = function () {
                scope.columnMaps.push({sql_left_column: null, sql_right_column: null});
                // No need to explicitly set scope.config here if sync is handled by $watchCollection
            };

            // Function to remove a column mapping object
            scope.removeColumnMapping = function (index) {
                scope.columnMaps.splice(index, 1);
                // No need to explicitly set scope.config here if sync is handled by $watchCollection
            };

            // Initial fetch if datasets are already present on load
            if (scope.datasets) {
                scope.fetchColumns();
            }

            scope.$on('$destroy', function() {

                // Reset the config property to null or empty array
                if (scope.config) {
                    scope.config[scope.configProperty] = null;
                    // OR if you prefer an empty array:
                    // scope.config[scope.configProperty] = [];
                }

                // Also reset the internal state
                scope.selectedItems = [];
                scope.isDropdownOpen = false;
            });
        }
    };
}]);
