from typing import Any, Dict, Type

from answers.backend.utils.knowledge_filters import get_current_filter_config
from answers.backend.utils.parameter_helpers import load_knowledge_bank_parameters


class SingletonMeta(type):
    _instances: Dict[Type, Any] = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super(SingletonMeta, cls).__call__(*args, **kwargs)
        return cls._instances[cls]


class KnowledgeBanksParams(metaclass=SingletonMeta):
    def __init__(self):
        self.__all_knowledge_bank_parameters, self.__per_knowledge_bank_parameters = load_knowledge_bank_parameters()
        self.__knowledge_bank_ids = self.__all_knowledge_bank_parameters["knowledge_bank_ids"]
        self.__knowledge_bank_vector_db_types = self.__all_knowledge_bank_parameters["knowledge_bank_vector_db_types"]
        self.__knowledge_bank_weighs = self.__all_knowledge_bank_parameters.get("knowledge_bank_weighs")
        self.__filters_config = get_current_filter_config()

    @property
    def all_knowledge_bank_parameters(self):
        return self.__all_knowledge_bank_parameters

    @property
    def knowledge_bank_ids(self):
        return self.__knowledge_bank_ids

    @property
    def knowledge_bank_vector_db_types(self):
        return self.__knowledge_bank_vector_db_types

    @property
    def knowledge_bank_weighs(self):
        return self.__knowledge_bank_weighs

    @property
    def filters_config(self):
        return self.__filters_config

    @property
    def per_knowledge_bank_parameters(self):
        return self.__per_knowledge_bank_parameters
