# Document constants:
PREVIEW_IMAGE_SHORT_SIDE = 150
PREVIEW_IMAGE_LONGSIDE = 200

MAX_UPLOAD_SIZE_MB = 15
MAX_N_UPLOAD_FILES = 5

IMAGE_EXTENSIONS = {"png", "jpg", "jpeg", "webp", "gif"}
DOCUMENT_EXTENSIONS = {"pdf", "docx", "py", "txt", "md", "json", "html", "js", "pptx"}

# Prompt constants:
PROMPT_DATE_FORMAT = "%Y-%m-%d %H:%M"
PROMPT_SEPARATOR_LENGTH = 10

# Troubleshooting constants:
CONVERSATION_DEFAULT_NAME = "New chat"
DEFAULT_TITLE_GENERATION_ERROR = "Title Generation Error: "
DEFAULT_DECISIONS_GENERATION_ERROR = "Decision generation Error: "

# Webapp parameters:
DEFAULT_TEMPERATURE = None # Default of DKULLM in DSS 14 to use a 'None' value for the temperature
LOWEST_TEMPERATURE = 0.0
DEFAULT_MAX_LLM_TOKENS: int = 2048

# LLM connection constants:
LLM_API_ERROR = "Error when attempting to call model or agent."

# Database constants:
SUPPORTED_DIALECT_VALUES = [
    "BigQuery",
    "Databricks",
    "SQLServer",
    "Redshift",
    "Snowflake",
    "PostgreSQL",
    "Oracle",
]
ALL_LONGTEXT_COLUMN_NAMES = [
    "question",
    "filters",
    "file_path",
    "answer",
    "sources",
    "feedback_message",
    "llm_context",
    "generated_media",
    "query",
    "history",
    "metadata"
]

LOGGING_DATES_FORMAT = "%Y-%m-%d %H:%M:%S"

KEYS_TO_REMOVE_FROM_LOGS = ['summary', 'full_extracted_text', 'preview', 'excerpt', 'file_data', 'trace', 'sample', 'columns', 'rows', 'textSnippet']


# TODO: frontend and backend should source from same location
CHAIN_MIME_TYPES = {
    "IMAGE" : {"image/png", "image/jpeg", "image/webp", "image/gif"},
    "DOCUMENT" : {
        "application/pdf",
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        "text/plain",
        "application/json",
        "text/x-python-script",
        "text/html",
        "text/javascript",
        "text/markdown",
        "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    }
}


BLACKLISTED_MIME_TYPES = [
    "application/x-msdownload",  # .exe, .dll
    "application/x-sh",  # .sh
    "application/x-bat",  # .bat
    "application/java-archive",  # .jar
    "application/zip",  # .zip
    "application/x-rar-compressed",  # .rar
    "application/x-7z-compressed",  # .7z
    "application/gzip",  # .gz
    "application/x-tar",  # .tar
    "application/x-iso9660-image",  # .iso
    "application/x-powershell",  # .ps1
    "application/vnd.android.package-archive",  # .apk
    "application/x-msi",  # .msi
]

MEDIA_CONVERSATION_START_TAG = "_START_MEDIA_QA_CONVERSATION_"