import type { ConversationInfo, Conversation } from './conversation'

export enum ResponseStatus {
  KO = 'ko',
  OK = 'ok'
}

export interface DataSample {
  rows: Record<string, any>[]
  columns: Record<string, any>[]
  query: string
}
interface RAGImage {
  full_folder_id: string
  file_path: string
  index: number
  file_data: string
}
export interface Source {
  type: string
  excerpt?: string
  metadata: Record<string, string | number | any[]>
  records?: DataSample 
  images: RAGImage[]
  usedTables: string 
  generatedSqlQuery: string
  title: string
  url: string
  textSnippet: string
  htmlSnippet: string
  markdownSnippet: string
  tool_name_used: string
}
export interface AggregatedToolSources {
  items?: Source[]
  toolCallDescription: string
}

export type FiltersData = { [key: string]: (string | number)[] }

export type FilterConfig = {
  input_dataset: string
  filter_metadata: string[]
  filter_options: Record<string, any[]>
}

export type RetrieverInfo = {
  name: string
  id: string
  alias: string
  activated: boolean
  type: RetrievalMode
}
export type UIData = {
  examples: string[]
  title: string
  subtitle: string
  language: string
  input_placeholder: string
  docs_folder_id?: string
  upload_folder_id?: string
  self_service_embedding_model?: string
  project: string
  feedback_negative_choices: string[]
  feedback_positive_choices: string[]
  retrieval_mode: RetrievalMode
  retriever_info: RetrieverInfo | null
  filters_config: FilterConfig | null
  display_sql_query: boolean
  sql_retrieval_connection?: string
  sql_retrieval_suggested_joins: string[]
  display_source_chunks?: boolean
  llm_capabilities: { multi_modal: boolean; streaming: boolean; image_generation: boolean }
  llm_id: string
  image_generation_llm_id: string
  user: string
  user_settings?: { from: string; to: string }[]
  current_user_profile?: any
  allow_general_feedback: boolean
  disclaimer: string
  use_custom_rebranding: boolean
  custom_theme_name: string
  custom_logo_file_name: string
  custom_icon_file_name: string
  supported_languages: any[]
  max_upload_size_mb: number
  max_n_upload_files: number
  max_images_per_user_per_week?: number
}
export interface AnswerData {
  answer: string
  sources: Source[]
  conversation_infos: ConversationInfo
  filters: FiltersData | null
  record_id: string | number
  user_profile: any | null
  generated_images: any[] | null
}

export interface FiltersRequest {
  query: string
}

export interface ConvTitleRequest {
  query: string
  answer: string
}

interface ServerResponse<T> {
  message: string
  status: ResponseStatus
  data: T
}
export interface RetrievalType {
  [key: string]: string | RetrievalMode
}

export interface AnswerRequest {
  conversation_id: string | null
  conversation_type: ConversationType
  query: string
  query_index: number | 0
  filters?: FiltersData | null
  chain_type?: string | null
  media_summaries?: MediaSummary[] | null
  topics?: string[] | null
  original_file_name?: string | null
  retrieval_enabled?: boolean | false
  retrieval_selection: RetrievalType[] | null
  user_profile?: any | null
}
export interface StreamedAnswerRequest extends AnswerRequest {
  record_id: string | number
}
export interface UploadRequest {
  conversation_id: string | null
  data: FormData
}
export interface MediaSummary {
  summary?: string
  topics?: string[]
  preview?: string
  questions?: string[]
  chain_type?: string
  metadata_path?: string
  file_path?: string
  original_file_name?: string
  token_estimate?: number
  is_deleted?: boolean
}

export interface UploadData {// TODO: we can maybe restructure this
  message: string
  file_id: string
  media_summaries: MediaSummary[]
}
export interface LoadFileData {
  file_path: string
  file_data: string
}
export enum FeedbackValue {
  NEGATIVE = 'NEGATIVE',
  POSITIVE = 'POSITIVE',
  GENERAL = 'GENERAL'
}
export interface GeneratedMedia {
  file_data: string
  file_format: string
  file_path: string
  referred_file_path: string
}
export enum LLLMStep {
  INIT = 'init',
  STREAMING = 'streaming',
  ANALYZING_KB = 'analyzing_kb',
  ANALYZING_NO_RETRIEVER = 'analyzing_no_retriever',
  ANALYZING_DB = 'analyzing_db',
  LOADING = 'loading',
  USING_FALLBACK_LLM = 'using_fallback_llm',
}
export enum UPLOAD_CHAIN_TYPES {
    IMAGE = "image",
    DOCUMENT_AS_IMAGE = "document_as_image",
    SHORT_DOCUMENT = "short_document",
    LONG_DOCUMENT = "long_document",
}

export enum RetrievalMode {
  KB = 'kb',
  DB = 'db',
  NO_RETRIEVER = 'no_retrieval'
}

export interface Feedback {
  value: FeedbackValue
  choice?: string[]
  message?: string | null
}

export interface DbSelection {
  sql_retrieval_table_list: string[]
  sql_query: string | null
}
export enum ConversationType {
  GENERAL = 'general',
  MEDIA_QA = 'media_qa',
}
export interface QuestionData {
  id: string
  query: string
  filters?: FiltersData | null
  answer: string
  sources: AggregatedToolSources[]
  feedback: Feedback | null
  chain_type?: string
  media_summary?: MediaSummary[] | null
  llm_kb_selection?: string[]
  dbSelection?: DbSelection //TODO one of these needs to change name
  llm_db_selection?: DbSelection //TODO one of these needs to change name
  kbOn?: boolean
  dbOn?: boolean
  step?: LLLMStep
  generated_images?: GeneratedMedia[]
  conversation_type?: ConversationType
  uploaded_docs?: MediaSummary[] | null,
  webAppId?: string
}

export type LogFeedbackResponse = ServerResponse<number>
export type FiltersResponse = ServerResponse<FiltersData>
export type UISetupResponse = ServerResponse<UIData>
export type AnswerResponse = ServerResponse<AnswerData>
export type ConversationsResponse = ServerResponse<ConversationInfo[]>
export type ConversationResponse = ServerResponse<Conversation>
export type UploadResponse = ServerResponse<UploadData[]>
export type LoadFileResponse = ServerResponse<LoadFileData>
export type ConversationTitleResponse = ServerResponse<{ title: string }>

export type ExpandSourceEvent = {
  sourceIndex: string
  citationIndex: string
  queryIndex: number
}

export enum UploadableFileTypes {
  IMAGE = 'image/png, image/jpeg, image/webp, image/gif,',
  DOCUMENT = 'application/pdf, application/vnd.openxmlformats-officedocument.wordprocessingml.document, text/plain, application/json, text/x-python-script, text/html, text/javascript, text/markdown, application/vnd.openxmlformats-officedocument.presentationml.presentation, '
}

export const UploadableFileExtensions  = '.png .jpeg .webp .gif .pdf .docx .json .py .html .js .md .pptx'
export const BLACKLISTED_MIME_TYPES = [
  'application/x-msdownload',       // .exe, .dll
  'application/x-sh',               // .sh
  'application/x-bat',              // .bat
  'application/java-archive',       // .jar
  'application/zip',                // .zip
  'application/x-rar-compressed',   // .rar
  'application/x-7z-compressed',    // .7z
  'application/gzip',               // .gz
  'application/x-tar',              // .tar
  'application/x-iso9660-image',    // .iso
  'application/x-powershell',       // .ps1
  'application/vnd.android.package-archive', // .apk
  'application/x-msi'               // .msi
]
