llmApp.directive('numberInputField',['PLUGIN_PATHS',function (PLUGIN_PATHS) {
    return {
        restrict: 'E',
        scope: {
            modelValue: '=',
            labelText: '@',
            minValue: '@',
            maxValue: '@',
            placeholder: '@',
            zeroMessage: '@',
            warningMessage: '@',
            description: '@',
            numberType: '@',
            subLabel: '@'
        },
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'number-input-template.html',
        // Inject the $interval service
        controller: ['$scope', '$interval', function ($scope, $interval) {
            $scope.inputFocused = false;

            // Variable to hold the interval promise
            var intervalPromise;

            // Parse min and max values to numbers
            $scope.minValueNum = parseFloat($scope.minValue) || 0;
            $scope.maxValueNum = parseFloat($scope.maxValue) || 100;

            if (!$scope.numberType) $scope.numberType = 'DOUBLE';
            $scope.step = $scope.numberType === 'INT' ? '1' : 'any';

            // Initial value setup
            if ($scope.modelValue === undefined || $scope.modelValue === null || isNaN($scope.modelValue)) {
                $scope.modelValue = $scope.numberType === 'INT' ? Math.round($scope.minValueNum) : $scope.minValueNum;
            }

            $scope.incrementValue = function() {
                const step = $scope.numberType === 'INT' ? 1 : 0.1;
                const currentValue = parseFloat($scope.modelValue) || 0;
                const newValue = currentValue + step;

                if (!$scope.maxValue || newValue <= parseFloat($scope.maxValue)) {
                    $scope.modelValue = $scope.numberType === 'INT' ? Math.round(newValue) : parseFloat(newValue.toFixed(1));
                }
            };

            $scope.decrementValue = function() {
                const step = $scope.numberType === 'INT' ? 1 : 0.1;
                const currentValue = parseFloat($scope.modelValue) || 0;
                const newValue = currentValue - step;

                if (!$scope.minValue || newValue >= parseFloat($scope.minValue)) {
                    $scope.modelValue = $scope.numberType === 'INT' ? Math.round(newValue) : parseFloat(newValue.toFixed(1));
                }
            };

            // Function to start incrementing on mousedown
            $scope.startIncrementing = function() {
                // First, cancel any existing interval
                $scope.stopActions();
                // Execute once immediately
                $scope.incrementValue();
                // Start a new interval to repeat the action
                intervalPromise = $interval($scope.incrementValue, 100); // Repeats every 100ms
            };

            // Function to start decrementing on mousedown
            $scope.startDecrementing = function() {
                $scope.stopActions();
                $scope.decrementValue();
                intervalPromise = $interval($scope.decrementValue, 100);
            };

            // Function to stop the interval on mouseup or mouseleave
            $scope.stopActions = function() {
                $interval.cancel(intervalPromise);
            };


/*            // Watch for undefined values and handle them
            $scope.$watch('modelValue', function(newVal) {
                if (newVal === undefined) {
                    $scope.invalidInput = true;
                } else {
                    $scope.invalidInput = false;
                }
            });*/

            // Add this function to your controller
            $scope.onInputChange = function() {
                // Use $timeout to ensure we get the updated modelValue
                $timeout(function() {

                    // Your logic here with the correct updated value
                    if ($scope.numberType === 'INT' && $scope.modelValue !== undefined && $scope.modelValue !== null) {
                        $scope.modelValue = Math.round(parseFloat($scope.modelValue));
                    }
                }, 0);
            };


            $scope.$watch('modelValue', function(newVal) {
                const value = parseFloat(newVal);

                const belowMin = $scope.minValue && value < parseFloat($scope.minValue);
                const aboveMax = $scope.maxValue && value > parseFloat($scope.maxValue);
                const isNotNumber = isNaN(value);

                if (isNotNumber || belowMin || aboveMax) {
                    $scope.invalidInput = true;
                } else {
                    $scope.invalidInput = false;
                }
            });

            // Ensure interval is cancelled when scope is destroyed
            $scope.$on('$destroy', function() {
                $scope.stopActions();
            });

        }]
    };
}]);