from enum import Enum
from typing import Any, Dict, List, Optional, TypedDict


class VectorStoreType(str, Enum):
    QDRANT_LOCAL = "QDRANT_LOCAL"
    CHROMA = "CHROMA"
    PINECONE = "PINECONE"
    AZURE_AI_SEARCH = "AZURE_AI_SEARCH"
    ELASTICSEARCH = "ELASTICSEARCH"
    VERTEX_AI_GCS_BASED = "VERTEX_AI_GCS_BASED"
    FAISS = "FAISS"


class EmbeddingRecipeType(str, Enum):
    NLP_LLM_RAG_EMBEDDING = "nlp_llm_rag_embedding"
    EMBED_DOCUMENTS = "embed_documents"


class KnowledgeBankFilterConfig(TypedDict):
    metadata_dataset_id: str
    embedding_recipe_type: EmbeddingRecipeType
    documents_folder_id: str
    info_metadata: List[str]
    filter_metadata: List[str]
    filter_options: Dict[str, List[Any]]
    vector_db_type: Optional[str]


class KnowledgeBankInfo(TypedDict):
    embedding_recipe_name: str
    embedding_recipe_type: EmbeddingRecipeType
    vector_store_type: str
    metadata_dataset_id: str
    documents_folder_id: str
    metadata_schema: List[Dict[str, str]]


class KnowledgeBankRetrievalParams(TypedDict):
    k: int
    search_type: str
    mmr_k: int
    mmr_diversity: float
    score_threshold: float


class KnowledgeBankParameters(TypedDict):
    id: str
    description: str
    name: str
    weight: float
    vector_db_type: str


PerKnowledgeBankParameters = Dict[str, KnowledgeBankParameters]


# Knowledge Bank metadata:
SOURCE_FILE_METADATA = "source_file"

DISPLAY_ONLY_MULTIMODAL_METADATAS: List[str] = [
    "source_pages"
]

METADATA_REPLACEMENTS: Dict[str, str] = {
    "source_file": "dku_file_path"
}

class VectorStoreSupportingMetadataFetch(str, Enum):
    CHROMA = "CHROMA"
    # TODO: Investigate enabling 'AZURE_AI_SEARCH'

SUPPORTED_METADATA_DATATYPES: List[str] = ["string"]