import os

from answers.backend.local_config import setup_dataiku_client
from answers.backend.utils.launch_utils import run_create_app
from common.llm_assist.logging import logger
from dotenv import load_dotenv
from flask import Flask


def create_app():
    app = Flask(__name__)
    logger.info("Creating Flask Application")
    load_dotenv()
    setup_dataiku_client()
    app, socketio = run_create_app(app)
    return app, socketio


if __name__ == "__main__":
    os.environ["FLASK_ENV"] = "development"
    app, socketio = create_app()
    app.debug = True
    logger.info("Running Application")
    socketio.run(app, host="127.0.0.1", port=5000, debug=True)
    # app.run(host="127.0.0.1", port=5000, debug=True)
