# Answers

## 💻 Recommended IDE Setup

[VSCode](https://code.visualstudio.com/) + [Volar](https://marketplace.visualstudio.com/items?itemName=Vue.volar) (and disable Vetur) + [TypeScript Vue Plugin (Volar)](https://marketplace.visualstudio.com/items?itemName=Vue.vscode-typescript-vue-plugin).

[Tailwind CSS InteliSense](https://marketplace.visualstudio.com/items?itemName=bradlc.vscode-tailwindcss): To get autocompletion for tailwindcss classes

## 🎨 Styling with Shadcn-Vue and Tailwind CSS
This repository leverages [Shadcn-Vue](https://www.shadcn-vue.com/) and [Tailwind CSS](https://tailwindcss.com/) for its styling and component library needs. 

- Shadcn-Vue provides a set of customizable, accessible Vue components that can be easily integrated and tailored to match the project's design requirements. 
- Paired with Tailwind CSS, a utility-first CSS framework, it enables rapid styling with pre-built utility classes for flexible and responsive layouts. 

Together, they offer a robust foundation for building consistent, modern, and maintainable user interfaces with minimal custom CSS.

### 📁 Shadcn-vue components

Every pulled `Shadcn` components can be found in the folder `./src/components/ui`

## Type Support for `.vue` Imports in TS

TypeScript cannot handle type information for `.vue` imports by default, so we replace the `tsc` CLI with `vue-tsc` for type checking. In editors, we need [TypeScript Vue Plugin (Volar)](https://marketplace.visualstudio.com/items?itemName=Vue.vscode-typescript-vue-plugin) to make the TypeScript language service aware of `.vue` types.

If the standalone TypeScript plugin doesn't feel fast enough to you, Volar has also implemented a [Take Over Mode](https://github.com/johnsoncodehk/volar/discussions/471#discussioncomment-1361669) that is more performant. You can enable it by the following steps:

1. Disable the built-in TypeScript Extension
    1) Run `Extensions: Show Built-in Extensions` from VSCode's command palette
    2) Find `TypeScript and JavaScript Language Features`, right click and select `Disable (Workspace)`
2. Reload the VSCode window by running `Developer: Reload Window` from the command palette.

## Customize configuration

See [Vite Configuration Reference](https://vitejs.dev/config/).

## Project Setup

```sh
yarn install
```

### Compile and Hot-Reload for Development

```sh
yarn dev
```

### Type-Check, Compile and Minify for Production

```sh
yarn build
```

### Lint with [ESLint](https://eslint.org/)

```sh
yarn lint
```
