from abc import ABC, abstractmethod
from typing import Any, Dict, Generator, List, Optional, Union

from common.backend.models.base import ConversationType, LlmHistory, LLMStepDesc, MediaSummary, RetrievalSummaryJson
from dataikuapi.dss.llm import (
    DSSLLMStreamedCompletionChunk,
    DSSLLMStreamedCompletionFooter,
)


class BaseLLMQuestionAnswering(ABC):
    @abstractmethod
    def get_answer_and_sources(  # noqa: PLR0917 too many positional arguments
        self,
        query: str,
        conversation_type: ConversationType,
        chat_history: List[LlmHistory] = [],
        filters: Optional[Dict[str, List[Any]]] = None,
        chain_type: Optional[str] = None,
        media_summaries: Optional[List[MediaSummary]] = None,
        previous_media_summaries: Optional[List[MediaSummary]] = None,
        retrieval_enabled: bool = False,
        user_profile: Optional[Dict[str, Any]] = None,
        force_non_streaming: bool = False,
    ) -> Generator[
        Union[
            LLMStepDesc,
            RetrievalSummaryJson,
            DSSLLMStreamedCompletionChunk,
            DSSLLMStreamedCompletionFooter,
        ],
        Any,
        None,
    ]:
        raise Exception("Not implemented")

    @abstractmethod
    def get_conversation_title(self, query: str, answer: str, user_profile: Optional[Dict[str, Any]] = None) -> str:
        raise Exception("Not implemented")

    @abstractmethod
    def get_llm_name(self) -> str:
        raise Exception("Not implemented")
