import time

from common.llm_assist.logging import logger

# TODO: This file and its location probably need to change if they are logging llm too


def log_query_time(func):
    def wrapper(*args, **kwargs):
        start_time = time.time()
        result = func(*args, **kwargs)
        end_time = time.time()
        logger.debug(
            f"Time ===> taken by  '{func.__name__}' to execute is {round(end_time - start_time, 3)}.")
        return result
    return wrapper
