let llmApp=angular.module("llmConfig.module",[]);llmApp.constant("PLUGIN_PATHS",{DOCUMENT_QA:"/plugins/document-question-answering/resource/custom-ui-settings/"}),llmApp.constant("SUPPORTED_CONNECTIONS",["PostgreSQL","Snowflake","Redshift","MS SQL Server","BigQuery","Databricks","Oracle"]),llmApp.controller("LLMConfigController",["$scope","$timeout","PythonService","DataikuAPI","SUPPORTED_CONNECTIONS","DescParamsService","$q","$window",function($scope,$timeout,PythonService,DataikuAPI,SUPPORTED_CONNECTIONS,DescParamsService,$q,$window){$scope.newConversationDataset=!1,$scope.newLoggingDataset=!1,$scope.isHistoryDatasetsExpanded=!1,$scope.supportedConnections=SUPPORTED_CONNECTIONS,$scope.isConversationsDatasetExpanded=!1,$scope.toggleExpand=function(propertyName){$scope[propertyName]=!$scope[propertyName]},$scope.toggleFlag=function(name){"Conversation"===name?$scope.newConversationDataset=!$scope.newConversationDataset:"Logging"===name&&($scope.newLoggingDataset=!$scope.newLoggingDataset)},DataikuAPI.admin.folderEdit.listContents("LOCAL_STATIC").then(function(response){return{success:!0,data:response.data,status:response.status}}).catch(function(error){return{success:!1,error:error,message:error.message||"Failed to retrieve content"}}),$scope.sections=[{id:"llmConfig",displayName:"LLM and Datasets",formName:"llmConfigSubForm"},{id:"llmConfigSection",displayName:"LLM Configuration",formName:"llmConfigSectionSubForm"},{id:"conversationStore",displayName:"Conversation Store",formName:"conversationStoreSubForm"},{id:"documentUpload",displayName:"Document Upload",formName:"documentUploadSubForm"},{id:"imageGeneration",displayName:"Image Generation",formName:"imageGenerationSubForm"},{id:"retrievalMode",displayName:"Retrieval method",formName:"retrievalModeSubForm"},{id:"answersApiConfiguration",displayName:"Answers API",formName:"answersApiSubForm"},{id:"endUserConfiguration",displayName:"Interface Customization",formName:"endUserConfigSubForm"},{id:"userProfileSettings",displayName:"User Profile",formName:"userProfileSubForm"},{id:"webApplication",displayName:"WebApplication",formName:"webApplicationSubForm"},{id:"generalFeedback",displayName:"General Feedback",formName:"generalFeedbackSubForm"}];var datasetCreatedListener=$scope.$on("datasetCreated",function(){$scope.$broadcast("dataNeedsRefresh")});function checkScrollPosition(){var scrollTop,scrollPercent,scrollableElement=document.querySelector('[ng-controller="CustomWebAppEditController"]');scrollableElement&&(scrollTop=scrollableElement.scrollTop,scrollPercent=(scrollTop+scrollableElement.clientHeight)/scrollableElement.scrollHeight,$scope.$apply(function(){$scope.showScrollToTop=300<scrollTop&&.3<scrollPercent}))}$scope.$on("$destroy",function(){datasetCreatedListener()}),$scope.navigateToSectionAndError=function(sectionWithError){$location.hash(sectionWithError.id),$timeout(function(){sectionWithError.firstErrorId&&document.getElementById(sectionWithError.firstErrorId);var sectionContainerId="section-"+sectionWithError.id,sectionContainerId=document.getElementById(sectionContainerId);sectionContainerId?sectionContainerId.scrollIntoView({behavior:"smooth",block:"start"}):(sectionContainerId=document.getElementsByName("configForm")[0])?sectionContainerId.scrollIntoView({behavior:"smooth",block:"start"}):window.scrollTo({top:0,behavior:"smooth"})},100)},$scope.$watch(function(){return $location.hash()},function(newHash){$scope.selectedSection=newHash?newHash.replace("#",""):"llmConfig"}),$scope.config=$scope.config||{},"function"==typeof $scope.callPythonDo?PythonService.registerCallPythonDoFunction($scope.callPythonDo):PythonService.registerCallPythonDoFunction(function(){return $q.reject("callPythonDo was not properly initialized in LLMConfigController for PythonService.")}),DescParamsService.registerDescParams($scope),$scope.descParams=DescParamsService.getDescParams(),void 0===$scope.selectedSection&&($scope.selectedSection="llmConfig"),$scope.showScrollToTop=!1,$scope.scrollToTop=function(){var controllerElement=document.querySelector('[ng-controller="LLMConfigController"]');controllerElement?controllerElement.scrollIntoView({behavior:"smooth"}):window.scrollTo({top:0,behavior:"smooth"})};var scrollableElement=document.querySelector('[ng-controller="CustomWebAppEditController"]');scrollableElement&&angular.element(scrollableElement).on("scroll",checkScrollPosition),$scope.$on("$destroy",function(){scrollableElement&&angular.element(scrollableElement).off("scroll",checkScrollPosition)})}]),llmApp.directive("loadingWatcher",function($rootScope,$timeout){return{restrict:"A",link:function(scope,element,attrs){$timeout(function checkSpinner(){var spinner=document.getElementById(".qa_spinner");$rootScope.isLoading=!!spinner,spinner&&$timeout(checkSpinner,100)},0)}}}),llmApp.directive("listenForSaveAndView",function(){return{restrict:"A",link:function(scope){function handleClick(event){for(var target=event.target;target&&target!==document;){if("BUTTON"===target.tagName||"A"===target.tagName){var elementText=target.textContent.trim().toLowerCase();if(elementText.includes("save and view webapp")||elementText.includes("save and view app")||elementText.includes("save & view")||elementText.includes("save"))return event.stopPropagation(),event.preventDefault(),void scope.$apply(function(){scope.configForm&&(scope.configForm.$submitted=!0),function validateForm(scope){scope.invalidSections=[];let isOverallFormInvalid=scope.showGlobalError=!1,form=scope.configForm;if(form)if(angular.forEach(scope.sections,function(section){var sectionForm=scope.configForm[section.formName];sectionForm&&sectionForm.$invalid&&(scope.invalidSections.push(section),isOverallFormInvalid=!0)}),isOverallFormInvalid)scope.showGlobalError=!0;else if(form.$valid)return form.$setPristine(),form.$setUntouched(),!0;return!1}(scope)?$timeout(function(){target.setAttribute("data-bypassed","true"),target.click()}):(scope.showValidationError=!0,$timeout(function(){var controllerElement=document.querySelector('[ng-controller="LLMConfigController"]');controllerElement&&controllerElement.scrollIntoView({behavior:"smooth"})}))})}target=target.parentElement}}function clickHandler(event){for(var target=event.target;target&&target!==document;){if(function isBypassedClick(target){return target.hasAttribute("data-bypassed")}(target))return void target.removeAttribute("data-bypassed");target=target.parentElement}handleClick(event)}document.addEventListener("click",clickHandler,!0),scope.$on("$destroy",function(){document.removeEventListener("click",clickHandler,!0)})}}}),llmApp.factory("DescParamsService",[function(){var service={},registeredDescParams=null;return service.registerDescParams=function(scope){scope&&scope.$parent&&scope.$parent.$parent&&scope.$parent.$parent.desc&&scope.$parent.$parent.desc.params&&(registeredDescParams=scope.$parent.$parent.desc.params)},service.getDescParams=function(){return registeredDescParams},service.getSelectChoices=function(fieldName){var field;return registeredDescParams?(field=registeredDescParams.find(item=>item.name===fieldName&&"SELECT"===item.type))?field.selectChoices:[]:null},service.setDescParams=function(params){registeredDescParams=params},service.getDefaultValue=function(paramName){var param;return registeredDescParams&&(param=registeredDescParams.find(function(p){return p.name===paramName})).hasOwnProperty("defaultValue")?param.defaultValue:null},service}]),llmApp.service("customFileUploaderService",["$q","$timeout",function($q,$timeout){let defaultIconURL=window.location.origin+"/plugins/document-question-answering/resource/custom-ui-settings/No_image_available.png";this.generateAppFilename=function(){var match=window.location.href.match(/projects\/([^\/]+)\/webapps\/([^\/]+)\/edit/);if(match){var id,projectName=match[1],match=match[2].split("_");if(2<=match.length)return id=match[0],projectName+`_${match.slice(1).join("_")}_`+id}return"unknown-project_unknown-app_unknown-id"},this.isImageFile=function(file){return file&&file.type&&file.type.startsWith("image/")},this.isImageFileByName=function(fileName){fileName=(fileName||"").toLowerCase().substring(fileName.lastIndexOf("."));return[".jpg",".jpeg",".png",".gif",".svg",".webp",".bmp"].includes(fileName)},this.getDefaultIconUrl=function(){return defaultIconURL},this.ensureSubFolderExists=function(uploadTargetType,uploadTargetPath,subFolderName){let subFolderPath=uploadTargetPath.replace(/\/$/,"")+"/"+subFolderName;return DataikuAPI.admin.folderEdit.createContent(uploadTargetType,subFolderPath,!0).then(()=>subFolderPath).catch(error=>{if(error.data?.detailedMessage?.includes("already exists"))return subFolderPath;throw error})},this.ensureThemeFolderExists=function(uploadTargetType,themeName,uploadTargetPath){let themePath=uploadTargetPath+"/"+themeName;return DataikuAPI.admin.folderEdit.createContent(uploadTargetType,themePath,!0).then(()=>themePath).catch(error=>{if(error.data?.detailedMessage?.includes("already exists"))return themePath;throw error})},this.ensureSubFolderExists=function(uploadTargetType,themePath,folderName){let subFolderPath=themePath+"/"+folderName;return DataikuAPI.admin.folderEdit.createContent(uploadTargetType,subFolderPath,!0).then(()=>subFolderPath).catch(error=>{if(error.data?.detailedMessage?.includes("already exists"))return subFolderPath;throw error})},this.fetchUploadedFiles=function(uploadTargetType){return DataikuAPI.admin.folderEdit.listContents(uploadTargetType)},this.listSubFolders=function(folderName="answers"){return this.fetchUploadedFiles("LOCAL_STATIC").then(response=>{response=("string"==typeof response?JSON.parse(response):response).data.find(function(item){return item&&item.name===folderName});return response&&response.children?response.children.filter(function(child){return child&&child.children}).map(function(child){return{label:child.name,value:child.name}}):[]}).catch(error=>[])},this.uploadFile=function(uploadTargetType,targetPath,file){return new $q((resolve,reject)=>{DataikuAPI.admin.folderEdit.uploadContent(uploadTargetType,targetPath,file,(response,error)=>{error?reject({file:file.name,error:error}):resolve({file:file.name,path:targetPath+"/"+file.name})})})},this.deleteFile=function(uploadTargetType,filePath){return DataikuAPI.admin.folderEdit.deleteContent(uploadTargetType,filePath)},this.getAcceptedImageTypes=function(){return["image/jpeg","image/jpg","image/png"]},this.isAcceptedImageType=function(fileType){return this.getAcceptedImageTypes().includes(fileType)},this.getDefaultAllowedFiles=function(){return{"custom.css":{types:["text/css","application/css"],folder:""},"fonts.css":{types:["text/css","application/css"],folder:"fonts"},image:{types:["image/png","image/jpeg"],folder:"images"}}},this.createFolder=function(uploadTargetType,folderName,parentPath){return this.ensureSubFolderExists(uploadTargetType,parentPath,"answers").then(answersPath=>DataikuAPI.admin.folderEdit.createContent(uploadTargetType,answersPath+"/"+folderName,!0).then(()=>({label:folderName,value:folderName})))},this.getAllFilesForTheme=function(apiResponseData,themeName,parentFolderName="answers"){if(!apiResponseData||!themeName)return[];apiResponseData=apiResponseData.find(item=>item.name===parentFolderName);if(!apiResponseData||!apiResponseData.children)return[];apiResponseData=apiResponseData.children.find(child=>child.name===themeName);if(!apiResponseData||!apiResponseData.children)return[];let files=[],collectFilesRecursively=items=>{items.forEach(item=>{item.children&&0<item.children.length?collectFilesRecursively(item.children):item.children||files.push(item)})};return collectFilesRecursively(apiResponseData.children),files}}]),llmApp.factory("KnowledgeBankService",["DataikuAPI",function(DataikuAPI){let SUPPORTED_METADATA_DATATYPES=["string"],DISPLAY_ONLY_MULTIMODAL_METADATAS=["source_pages"],REPLACED_METADATAS=["dku_file_path"],SUPPORTS_VECTOR_DB_FILTER=["QDRANT_LOCAL","CHROMA","PINECONE"],service={listKnowledgeBanks:function(projectKey){let choices=[];return DataikuAPI.retrievableknowledge.list(projectKey).then(function(response){return response.data.forEach(item=>{choices.push({value:item.id,label:item.name})}),{choices:choices}})},getKbSearchType:function(projectKey,knowledgeBankId){let choices=[{value:"similarity",label:"Similarity score only"},{value:"dss_similarity_score_threshold",label:"Similarity score with threshold (unbounded)"},{value:"similarity_score_threshold",label:"Similarity score with threshold (bounded within [0, 1) )"}];return service.getKnowledgeBankSettings(projectKey,knowledgeBankId).then(function(kBConfig){return"AZURE_AI_SEARCH"===kBConfig.vectorStoreType?choices.push({value:"hybrid",label:"Hybrid search"},{value:"semantic_hybrid",label:"Semantic hybrid search"}):choices.push({value:"mmr",label:"Improve diversity of documents"}),{choices:choices}})},getKnowledgeBankInfo:function(knowledgeBankId,flowNodesData,knowledgeBankSettings){var predecessorId,knowledgeBankId=service.findAntecedentRecipeNode(flowNodesData,knowledgeBankId),embedding_recipe_name=knowledgeBankId.name,embedding_recipe_type=knowledgeBankId.recipeType;let metadata_dataset_id="",documents_folder_id="";for(predecessorId of knowledgeBankId.predecessors||[]){var predNode=flowNodesData[predecessorId];predNode&&("LOCAL_DATASET"===predNode.nodeType?metadata_dataset_id=flowNodesData[predecessorId].name:"LOCAL_MANAGED_FOLDER"===predNode.nodeType&&(documents_folder_id=flowNodesData[predecessorId].name))}var metadataInfo,metadata_schema=[];for(metadataInfo of knowledgeBankSettings.metadataColumnsSchema||[]){var metadataDatatype=metadataInfo.type;SUPPORTED_METADATA_DATATYPES.includes(metadataDatatype)&&metadata_schema.push(metadataInfo.name)}return{embedding_recipe_name:embedding_recipe_name,embedding_recipe_type:embedding_recipe_type,vector_store_type:knowledgeBankSettings.vectorStoreType,metadata_dataset_id:metadata_dataset_id,documents_folder_id:documents_folder_id,metadata_schema:metadata_schema}},findAntecedentRecipeNode:function(flowNodesData,successorId){let antecedentNode=null;for(var[nodeId,node]of Object.entries(flowNodesData)){var successor;for(successor of node.successors||[])if(flowNodesData[successor].name===successorId){antecedentNode=node;break}if(null!==antecedentNode)break}return antecedentNode},getKnowledgeBankSettings:function(projectKey,knowledgeBankId){return DataikuAPI.retrievableknowledge.get(projectKey,knowledgeBankId).then(function(response){return response.data}).catch(function(error){return Logger.error("Error fetching the Knowledge Bank config:",error),{}})},getFlowGraph:function(projectKey){return DataikuAPI.flow.recipes.getGraph(projectKey)},getKnowledgeBankMetadata:function(projectKey,knowledgeBankId,parameterName,forMultiselect){let choices=[];return service.getFlowGraph(projectKey).then(function(response){return response.data.serializedFilteredGraph.serializedGraph.nodes}).then(function(flowNodesData){return service.getKnowledgeBankSettings(projectKey,knowledgeBankId).then(function(kBConfig){kBConfig=service.getKnowledgeBankInfo(knowledgeBankId,flowNodesData,kBConfig);return forMultiselect?("embed_documents"===kBConfig.embedding_recipe_type&&(choices.push({value:"source_file",label:"source_file"}),"knowledge_sources_filters"!==parameterName)&&DISPLAY_ONLY_MULTIMODAL_METADATAS.forEach(item=>{choices.push({value:item,label:item})}),"knowledge_sources_filters"!==parameterName||SUPPORTS_VECTOR_DB_FILTER.includes(kBConfig.vector_store_type)?(kBConfig.metadata_schema.forEach(item=>{REPLACED_METADATAS.includes(item)||choices.push({value:item,label:item})}),{choices:choices}):{choices:[]}):("embed_documents"===kBConfig.embedding_recipe_type&&choices.push({value:"source_file",label:"source_file"}),kBConfig.metadata_schema.forEach(item=>{REPLACED_METADATAS.includes(item)||choices.push({value:item,label:item})}),{choices:choices})})})}};return service}]),llmApp.factory("ParamsHelperService",["DataikuAPI","APIXHRService","$q","KnowledgeBankService","Logger",function(DataikuAPI,APIXHRService,$q,KnowledgeBankService,Logger){let CONNECTION_TYPES={POSTGRES:"PostgreSQL",SNOWFLAKE:"Snowflake",REDSHIFT:"Redshift",SQLSERVER:"SQLServer",BIGQUERY:"BigQuery",DATABRICKS:"Databricks",ORACLE:"Oracle"},service={do:function(payload,config,pluginConfig,inputs){var parameterName=payload.parameterName,projectKey=payload.projectKey;switch(parameterName){case"llm_id":case"json_decision_llm_id":case"title_llm_id":case"image_generation_llm_id":return service.listLlmsByConnectionsType(projectKey,payload.purpose,payload.typesToExclude);case"connection_selector":case"sql_retrieval_connection":return service.listConnectionsByType();case"knowledge_bank_id":return KnowledgeBankService.listKnowledgeBanks(projectKey);case"knowledge_retrieval_search_type":if("kb"===config.retrieval_mode&&config.knowledge_bank_id)return KnowledgeBankService.getKbSearchType(projectKey,config.knowledge_bank_id);case"upload_folder":return service.listProjectManagedFolders(projectKey);case"knowledge_source_url":case"knowledge_source_title":case"knowledge_source_thumbnail":case"knowledge_sources_context_metadata":case"knowledge_sources_filters":case"knowledge_sources_displayed_metas":if("kb"===config.retrieval_mode&&config.knowledge_bank_id){let forMultiselect=!1;return["knowledge_sources_context_metadata","knowledge_sources_filters","knowledge_sources_displayed_metas"].includes(parameterName)&&(forMultiselect=!0),KnowledgeBankService.getKnowledgeBankMetadata(projectKey,config.knowledge_bank_id,parameterName,forMultiselect)}case"sql_retrieval_table_list":return service.listDatasetsFromConnection(projectKey,config.sql_retrieval_connection);case"columns_mappings":return service.getDatasetColumnsMapping(projectKey,payload.selectedDatasets);case"datasets_names":return service.listDatasetsByConnectionTypes(projectKey);case"create_dataset":return service.createDataset(projectKey,payload.arguments.name,payload.arguments.connection);default:return $q.resolve({choices:[{value:"wrong",label:`Problem handling the parameter with payload ${JSON.stringify(payload)}.`}]})}},listLlmsByConnectionsType:function(projectKey,purpose,typesToExclude){return DataikuAPI.pretrainedModels.listAvailableLLMs(projectKey,purpose=purpose||"GENERIC_COMPLETION").then(function(response){let llmByType={};return(response.data&&response.data.identifiers?response.data.identifiers:[]).forEach(function(llm){var llmType=llm.type;-1===typesToExclude.indexOf(llmType)&&(llmByType[llmType]||(llmByType[llmType]=[]),llmByType[llmType].push({value:llm.id,label:llm.friendlyName,type:llmType}))}),{choices:llmByType}}).catch(function(error){return Logger.error("Error listing LLMs by connection type",error),{choices:{}}})},listConnectionsByType:function(){var promises=Object.values(CONNECTION_TYPES).map(function(connectionType){return DataikuAPI.connections.getNames(connectionType).then(function(response){response=response.data||[];return{type:connectionType,connections:response}}).catch(function(error){return Logger.error("Error processing connection type "+connectionType,error),{type:connectionType,connections:[]}})});return $q.all(promises).then(function(results){let connectionMap={};return results.forEach(function(result){result.connections&&0<result.connections.length&&(connectionMap[result.type]||(connectionMap[result.type]=[]),result.connections.forEach(function(connectionName){connectionMap[result.type].push(connectionName)}))}),{choices:connectionMap}})},listDatasetsFromConnection:function(projectKey,connectionName){let connectionType="",dataset_choices=[];return DataikuAPI.datasets.list(projectKey).then(function(response){return response.data.forEach(item=>{item.params.connection===connectionName&&(dataset_choices.push({value:item.name,label:item.name}),connectionType=item.type)}),{choices:{[connectionType]:dataset_choices}}}).catch(function(error){return Logger.error("Error listing the project datasets on the connection "+connectionName,error),{choices:[{value:"",label:"None"}]}})},getDatasetColumnsMapping:function(projectKey,datasetNames){let choices=[];datasetNames=datasetNames.map(datasetName=>DataikuAPI.datasets.get(projectKey,datasetName,projectKey).then(function(response){response.data.schema.columns.forEach(colData=>{choices.push({value:datasetName+"."+colData.name,label:datasetName+"."+colData.name})})}).catch(function(error){return Logger.error(`Error listing the columns from project dataset '${datasetName}'`,error),null}));return Promise.all(datasetNames).then(()=>({choices:choices}))},listDatasetsByConnectionTypes:function(projectKey){let connectionDatasets={},connectionTypes=Object.values(CONNECTION_TYPES);return DataikuAPI.datasets.list(projectKey).then(function(response){return response.data.forEach(item=>{var connType=item.type,item=item.name;connectionTypes.includes(connType)&&(connectionDatasets[connType]??=[]).push(item)}),{choices:connectionDatasets}}).catch(function(error){return Logger.error("Error listing datasets by connection types",error),{choices:[{value:"",label:"None"}]}})},createDataset:function(projectKey,datasetName,connectionParams){var managedDatasetCreationSettings={connectionId:connectionParams.connectionName,partitioningOptionId:"NP",typeOptionId:null,inlineDataset:!1,preserveOrder:!0,zone:null,markCreatedAsBuilt:!0,specificSettings:{FormatOptionId:null,overrideSQLCatalog:null,overrideSQLSchema:null}};return console.log("Creating the dataset "+datasetName),DataikuAPI.datasets.newManagedDataset(projectKey,datasetName,managedDatasetCreationSettings).then(function(){return{success:!0,dataset:{id:datasetName,datasetName:datasetName,datasetDisplayName:datasetName,datasetType:connectionParams.connectionType},message:`Dataset '${datasetName}' created successfully`}}).catch(function(error){return Logger.error("Error creating the project dataset",error),{choices:[{value:"",label:"None"}]}})},listProjectManagedFolders:function(projectKey){return DataikuAPI.managedfolder.list(projectKey).then(function(response){let choices=[{value:"",label:"None"}];return response.data.forEach(item=>{choices.push({value:item.id,label:item.name})}),{choices:choices}}).catch(function(error){return Logger.error("Error listing the project managed folders",error),{choices:[{value:"",label:"None"}]}})}};return service}]),llmApp.factory("PythonService",["$q",function($q){let _registeredCallPythonDo=null;return{registerCallPythonDoFunction:function(fn){_registeredCallPythonDo="function"==typeof fn?fn:null},unregisterCallPythonDoFunction:function(){_registeredCallPythonDo=null},callPythonDo:function(params){if("function"!=typeof _registeredCallPythonDo)return $q.reject("callPythonDo function not registered in PythonService");try{return _registeredCallPythonDo(params)}catch(e){return $q.reject("Error in registered callPythonDo: "+e.message)}}}}]),llmApp.factory("SharedDataService",function(){var state={};return{setprojectKey:function(key){null!==key&&"string"!=typeof key?console.warn("Invalid projectKey",key):(state.projectKey=key,console.log("projectKey set to "+key))},getprojectKey:function(){return state.projectKey}}}),llmApp.service("SharedPromiseService",function($q,PythonService,ParamsHelperService,SharedDataService){function fetchData(param){return ParamsHelperService.do({parameterName:param}).then(function(data){return dataPromises[param]=$q.when(data),data}).catch(function(error){return delete dataPromises[param],$q.reject(error)})}var dataPromises={};this.getData=function(param){return dataPromises[param]||(dataPromises[param]=fetchData(param)),dataPromises[param]},this.refreshData=function(param){var refreshPromise=fetchData(param);return dataPromises[param]=refreshPromise,dataPromises[param]},this.clearCache=function(param){delete dataPromises[param]}}),llmApp.directive("answersApiConfiguration",["PLUGIN_PATHS","SUPPORTED_CONNECTIONS",function(PLUGIN_PATHS,SUPPORTED_CONNECTIONS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"answers-api-configuration.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.isExpanded=!1,$scope.isAnswersHistoryDataset=!1,$scope.isAnswersConversationDataset=!1,$scope.config=$scope.config||{},$scope.supportedConnections=SUPPORTED_CONNECTIONS,$scope.state={newMessagesHistoryDataset:!1,newConversationHistoryDataset:!1},$scope.toggleFlag=function(name){"MessageHistory"===name?$scope.state.newMessagesHistoryDataset=!$scope.state.newMessagesHistoryDataset:"ConversationHistory"===name&&($scope.state.newConversationHistoryDataset=!$scope.state.newConversationHistoryDataset)},$scope.toggleExpand=function(propertyName){$scope[propertyName]=!$scope[propertyName]}}]}}]),llmApp.directive("conversationStoreConfig",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"conversation-store-config.html",scope:{config:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.config=$scope.config||{}}]}}]),llmApp.directive("documentUploadConfig",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"document-upload-config.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.isDocumentUploadExpanded=!1,$scope.isResizeScalePdfExpanded=!1,$scope.isResizeScalePptxExpanded=!1,$scope.toggleExpand=function(propertyName){$scope[propertyName]=!$scope[propertyName]}}]}}]),llmApp.directive("endUserConfiguration",["customFileUploaderService","$timeout","PLUGIN_PATHS",function(customFileUploaderService,$timeout,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"end-user-configuration.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.config=$scope.config||{},$scope.folderChoices=[],$scope.use_examples=!0,$scope.isLogoExpanded=!1,$scope.isExampleExpanded=!1,$scope.isChatIconExpanded=!1,$scope.isFolderThemeExpanded=!1,$scope.toggleExpand=function(propertyName){$scope[propertyName]=!$scope[propertyName]},$scope.config.custom_theme_name||($scope.config.custom_theme_name="Default customization",$scope.config.use_custom_rebranding="false"),$scope.handleImageSelected=function(selectedImage,configProperty){$scope.$broadcast("imageSelectedFromSelector",{configProperty:configProperty,selectedImage:selectedImage})},$scope.$on("imageUploaded",function(event,data){$scope.$broadcast("refreshImageSelector",data)}),$scope.$on("imageDeleted",function(event,data){$scope.$broadcast("refreshImageSelector",data)}),$scope.config.use_custom_rebranding||($scope.config.use_custom_rebranding="false"),$scope.$on("folderCreated",function(){$scope.$broadcast("folderRefreshRequested")}),$scope.$watch("config.custom_theme_name",function(newVal){newVal&&"Default customization"!==newVal&&($scope.config.use_custom_rebranding=!0),""!==newVal&&null!==newVal||($scope.config.use_custom_rebranding=!1)})}]}}]),llmApp.directive("generalFeedback",["PLUGIN_PATHS","SUPPORTED_CONNECTIONS",function(PLUGIN_PATHS,SUPPORTED_CONNECTIONS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"general-feedback.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.config=$scope.config||{},$scope.isGeneralFeedbackSettingsExpanded=!1,$scope.supportedConnections=SUPPORTED_CONNECTIONS,$scope.toggleExpand=function(propertyName){$scope[propertyName]=!$scope[propertyName]},$scope.state={newGeneralFeedbackDataset:!1},$scope.toggleFlag=function(name){"GeneralFeedback"===name&&($scope.state.newGeneralFeedbackDataset=!$scope.state.newGeneralFeedbackDataset)},$scope.config.allow_general_feedback||($scope.config.allow_general_feedback=!1)}]}}]),llmApp.directive("imageGeneration",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"image-generation.html",scope:{config:"=",configForm:"="}}}]),llmApp.directive("llmConfigurationSection",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"llm-configuration-section.html",scope:{config:"=",configForm:"="}}}]),llmApp.directive("retrievalKnowledge",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"retrieval-knowledge-config.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.isExpanded=!1,$scope.toggleExpand=function(){$scope.isExpanded=!$scope.isExpanded},$scope.config.db_query_examples||($scope.config.db_query_examples={})}]}}]),llmApp.directive("userProfileSettings",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"user-profile-settings.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.isUserProfileSettingsExpanded=!1,$scope.toggleExpand=function(propertyName){$scope[propertyName]=!$scope[propertyName]}}]}}]),llmApp.directive("webAppConfiguration",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"web-app-configuration.html",scope:{config:"=",configForm:"="}}}]),llmApp.directive("advancedLlmSettings",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",llmLabel:"@",llmMaxTokens:"=",llmTemperature:"=",minLlmTemperature:"@",minLlmTokens:"@"},templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"advanced-llm-settings.html",controller:["$scope",function($scope){$scope.llmLabel||($scope.llmLabel=""),$scope.llmMaxTokens||($scope.llmMaxTokens=null),$scope.llmTemperature||($scope.llmTemperature=null),$scope.isExpanded=!1,$scope.toggleExpand=function(){$scope.isExpanded=!$scope.isExpanded}}]}}]),llmApp.directive("autoResize",["$timeout",function($timeout){return{restrict:"A",require:"ngModel",link:function(scope,element,attrs,ngModel){var span=document.createElement("span");function updateWidth(){var text=element.val()||element.attr("placeholder")||"",computedStyles=window.getComputedStyle(element[0]),paddingLeft=(span.style.display="inline-block",span.style.whiteSpace="pre",span.style.direction=computedStyles.direction,span.style.fontFamily=computedStyles.fontFamily,span.style.fontSize=computedStyles.fontSize,span.style.fontWeight=computedStyles.fontWeight,span.style.fontStyle=computedStyles.fontStyle,span.style.letterSpacing=computedStyles.letterSpacing,span.style.textTransform=computedStyles.textTransform,span.style.lineHeight=computedStyles.lineHeight,computedStyles.fontVariant&&(span.style.fontVariant=computedStyles.fontVariant),parseFloat(computedStyles.paddingLeft)||0),computedStyles=parseFloat(computedStyles.paddingRight)||0,text=(span.textContent=text,span.offsetWidth+paddingLeft+computedStyles+10);element[0].style.width=text+"px"}span.style.position="absolute",span.style.visibility="hidden",span.style.whiteSpace="pre",document.body.appendChild(span),element.on("input",updateWidth),ngModel.$render=function(){element.val(ngModel.$viewValue),$timeout(updateWidth,0)},$timeout(updateWidth,0),scope.$on("$destroy",function(){span.remove()})}}}]),llmApp.directive("checkboxDirective",["$timeout","DescParamsService","PLUGIN_PATHS",function($timeout,DescParamsService,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"checkbox-template.html",scope:{configProperty:"@",elementId:"@",config:"=",descriptionText:"@"},link:function(scope,element){scope.config[scope.configProperty]||(DescParamsService.getDefaultValue(scope.configProperty)?scope.config[scope.configProperty]=DescParamsService.getDefaultValue(scope.configProperty):scope.config[scope.configProperty]=!1)}}}]),llmApp.directive("columnMappings",["PythonService","ParamsHelperService","$timeout","PLUGIN_PATHS",function(PythonService,ParamsHelperService,$timeout,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"column-mappings-template.html",scope:{config:"=",formName:"=",datasets:"<",isRequired:"@?",configProperty:"@?",context:"@"},link:function(scope){scope.isRequired="true"===scope.isRequired,scope.showDeleteTooltip={},scope.config[scope.configProperty]=scope.config[scope.configProperty]||[],scope.columnMaps=scope.config[scope.configProperty],scope.availableColumns=[];let projectKey=$stateParams.projectKey;scope.fetchColumns=function(){var payload;scope.availableColumns=[],!scope.datasets||Array.isArray(scope.datasets)&&0===scope.datasets.length?scope.columnMaps=[]:(payload={parameterName:"columns_mappings",projectKey:projectKey,selectedDatasets:scope.datasets},ParamsHelperService.do(payload).then(function(data){data&&Array.isArray(data.choices)?$timeout(function(){scope.availableColumns=data.choices},0):scope.availableColumns=[]},function(error){scope.availableColumns=[]}))},scope.$watch("datasets",function(newVal,oldVal){angular.equals(newVal,oldVal)||scope.fetchColumns()},!0),scope.addColumnMapping=function(){scope.columnMaps.push({sql_left_column:null,sql_right_column:null})},scope.removeColumnMapping=function(index){scope.columnMaps.splice(index,1)},scope.datasets&&scope.fetchColumns()}}}]),llmApp.directive("columnSelector",["$timeout","PLUGIN_PATHS",function($timeout,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"column-selector-template.html",scope:{selectedColumn:"=",columnChoices:"<",formName:"=",labelText:"@",fieldRequired:"=",fieldName:"@",placeholder:"@?"},link:function(scope,element){scope.isDropdownOpen=!1,scope.filterText="",scope.isFocused=!1;var blurTimeout=null;function processColumnChoices(){scope.columnsByTable={},scope.columnChoices&&(scope.columnChoices.forEach(col=>{var parts=col.value.split(".");col.table=parts[0],col.column=parts.slice(1).join(".")||col.value}),scope.columnChoices.forEach(col=>{scope.columnsByTable[col.table]||(scope.columnsByTable[col.table]=[]),scope.columnsByTable[col.table].push(col)}))}scope.$watch("selectedColumn",function(newVal){var selectedOption;newVal?(selectedOption=scope.columnChoices.find(c=>c.value===newVal),scope.filterText=selectedOption?selectedOption.label:""):scope.filterText=""}),processColumnChoices(),scope.$watch("columnChoices",function(newChoices,oldChoices){angular.equals(newChoices,oldChoices)||(newChoices&&0<newChoices.length?(processColumnChoices(),scope.selectedColumn&&((oldChoices=newChoices.find(c=>c.value===scope.selectedColumn))?scope.filterText!==oldChoices.label&&(scope.filterText=oldChoices.label):(scope.selectedColumn=null,scope.filterText=""))):(scope.columnsByTable={},scope.filterText=""))},!0),scope.typeHasMatchingColumns=function(table){return!(!scope.columnsByTable||!scope.columnsByTable[table])&&scope.columnsByTable[table].some(col=>scope.columnMatchesFilter(col))},scope.columnMatchesFilter=function(column){var filter;return!scope.filterText||(filter=scope.filterText.toLowerCase(),column.column.toLowerCase().includes(filter))||column.table.toLowerCase().includes(filter)};function documentClickHandler(event){scope.isDropdownOpen&&!element[0].contains(event.target)&&scope.$apply(function(){scope.closeDropdownAndRevertText()})}scope.closeDropdownAndRevertText=function(){var selectedOption;scope.isDropdownOpen=!1,angular.element(document).off("click",documentClickHandler),scope.selectedColumn?(selectedOption=scope.columnChoices.find(c=>c.value===scope.selectedColumn),scope.filterText=selectedOption?selectedOption.label:""):scope.filterText=""},scope.openDropdown=function($event){$event&&$event.stopPropagation(),blurTimeout&&$timeout.cancel(blurTimeout),scope.isDropdownOpen||(scope.isDropdownOpen=!0,$timeout(function(){angular.element(document).on("click",documentClickHandler)},0))},scope.selectColumn=function(column){blurTimeout&&$timeout.cancel(blurTimeout),scope.selectedColumn=column.value,scope.filterText=column.label,scope.isDropdownOpen=!1,angular.element(document).off("click",documentClickHandler)},scope.clearSelection=function(){scope.filterText="",scope.selectedColumn=null,scope.openDropdown(),element[0].querySelector("input").focus()},scope.handleInputChange=function(){var selectedOption;!scope.selectedColumn||(selectedOption=scope.columnChoices.find(c=>c.value===scope.selectedColumn))&&scope.filterText===selectedOption.label||(scope.selectedColumn=null),!scope.isDropdownOpen&&scope.filterText&&scope.openDropdown()},scope.handleInputBlur=function(){blurTimeout=$timeout(function(){scope.isDropdownOpen&&scope.closeDropdownAndRevertText()},200)},scope.columnMatchesFilter=function(column){var filter;return!scope.filterText||(filter=scope.filterText.toLowerCase(),column.label.toLowerCase().includes(filter))},scope.hasMatchingColumns=function(){return 0!==scope.columnChoices.length&&(!scope.filterText||scope.columnChoices.some(col=>scope.columnMatchesFilter(col)))},scope.$on("$destroy",function(){blurTimeout&&$timeout.cancel(blurTimeout),angular.element(document).off("click",documentClickHandler)})}}}]),llmApp.directive("contenteditable",function(){return{require:"ngModel",link:function(scope,element,attrs,ngModel){ngModel.$render=function(){element.html(ngModel.$viewValue||"")},element.on("blur keyup change",function(){scope.$apply(function(){ngModel.$setViewValue(element.html())})})}}}),llmApp.directive("customFileUploader",["$q","$timeout","customFileUploaderService","PLUGIN_PATHS",function($q,$timeout,fileService,PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",configProperty:"@",labelText:"@",buttonText:"@",acceptedMimeTypes:"@",uploadTargetType:"@",uploadTargetPath:"@",showPreview:"@",onUploadComplete:"&?",uploadType:"@",expectedFileName:"@",description:"@"},templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"file-uploader.html",link:function(scope,element,attrs){scope.isDragOver=!1,scope.isUploading=!1,scope.uploadSuccess=null,scope.clientErrorMessage=null,scope.uploadStatusMessage=null,scope.uploadedFiles=[],scope.fileName=null,scope.previewSrc=fileService.getDefaultIconUrl(),scope.shouldShowPreview="false"!==scope.showPreview,scope.uploadType=scope.uploadType||"file",scope.config[scope.configProperty]=scope.config[scope.configProperty]||"",scope.showDeleteTooltip=!1;let fileInputElement=element.find('input[type="file"]')[0],isInitialized=(fileInputElement.multiple="multiple-files"===scope.uploadType||"folder"===scope.uploadType,!1);function getThemeName(){return scope.config=scope.config||{},scope.config.custom_theme_name||(scope.config.custom_theme_name="Default customization"),scope.config.custom_theme_name}function refreshComponentState(shouldClearMessages=!1){if(scope.fileName=null,scope.previewSrc=fileService.getDefaultIconUrl(),scope.uploadedFiles=[],shouldClearMessages&&clearMessages(),scope.config){let themeName=getThemeName();if(themeName)if("Default customization"===themeName&&scope.shouldShowPreview){let file={};"custom_logo_file_name"==scope.configProperty?(file={name:"custom_logo_file_name.png"},scope.previewSrc=window.location.origin+"/plugins/document-question-answering/resource/custom-ui-settings/images/custom_logo_file_name.png"):(file={name:"custom_icon_file_name.png"},scope.previewSrc=window.location.origin+"/plugins/document-question-answering/resource/custom-ui-settings/images/custom_icon_file_name.png"),void(scope.uploadedFiles=[file])}else fileService.fetchUploadedFiles(scope.uploadTargetType).then(response=>{var response=fileService.getAllFilesForTheme(response.data,themeName);let foundFile=null;if(scope.expectedFileName)foundFile=response.find(file=>file.name===scope.expectedFileName);else{let storedFileName=scope.config[scope.configProperty];storedFileName&&(foundFile=response.find(file=>file.name===storedFileName))}foundFile?(response=foundFile.name,scope.config[scope.configProperty]=response,scope.fileName=response,scope.shouldShowPreview&&fileService.isImageFileByName(response)&&(scope.previewSrc=`${window.location.origin}/local/static/answers/${themeName}/images/${response}?v=`+(new Date).getTime()),scope.uploadedFiles=[foundFile]):(scope.fileName=null,scope.previewSrc=fileService.getDefaultIconUrl(),scope.uploadedFiles=[])}).catch(error=>{scope.config[scope.configProperty]=null,scope.fileName=null,scope.previewSrc=fileService.getDefaultIconUrl(),scope.uploadedFiles=[]});else scope.config[scope.configProperty]=null}}function clearMessages(){$timeout(()=>{scope.clientErrorMessage=null,scope.uploadStatusMessage=null,scope.uploadSuccess=null},0)}function updateUploadStatus(message){$timeout(()=>{scope.uploadStatusMessage=message},0)}function hideMessageAfterDelay(){$timeout(()=>{scope.uploadStatusMessage=null,scope.uploadSuccess=null},5e3)}scope.triggerFileInput=function(){scope.isUploading||fileInputElement.click()},scope.handleFileSelect=function(files){if(files&&files.length&&!scope.isUploading){scope.isUploading=!0,scope.clientErrorMessage=null,updateUploadStatus("Validating files...");let{validFiles,errors,previewFile}=function validateFiles(files){files=Array.from(files);let defaultAllowedFiles=fileService.getDefaultAllowedFiles(),result={validFiles:[],errors:[],previewFile:null};return files.forEach(file=>{var{name:fileName,type:fileType}=file,lowerCaseFileName=fileName.toLowerCase(),lowerCaseFileName=fileService.isImageFile(file)?defaultAllowedFiles.image:defaultAllowedFiles[lowerCaseFileName];scope.acceptedMimeTypes?.includes("image/")&&!fileService.isImageFile(file)?result.errors.push("Unsupported file type. Please upload a file in .png, .jpg, or .jpeg format."):scope.expectedFileName&&scope.expectedFileName!==fileName?result.errors.push(`Invalid file.Please upload a file named ${scope.expectedFileName} in .css format.`):fileService.isImageFile(file)&&!fileService.isAcceptedImageType(fileType)?result.errors.push(`Invalid image type: ${fileType}. Only JPG, JPEG and PNG are supported.`):lowerCaseFileName?(result.validFiles.push({file:file,folder:lowerCaseFileName.folder||""}),"multiple-files"!==scope.uploadType&&scope.shouldShowPreview&&fileService.isImageFile(file)&&!result.previewFile&&(result.previewFile=file)):result.errors.push(`Invalid file name: ${fileName}.`)}),result}(files);0<errors.length?$timeout(()=>{scope.isUploading=!1,scope.clientErrorMessage=errors.join("; "),$timeout(()=>{scope.uploadStatusMessage=""},0)},0):(previewFile&&((files=new FileReader).onload=e=>scope.$applyAsync(()=>scope.previewSrc=e.target.result),files.readAsDataURL(previewFile)),function performUpload(validFiles,themeName){if(0===validFiles.length)scope.isUploading=!1,updateUploadStatus("No valid files to upload.");else{var primaryFile=validFiles[0].file;let fileNameToRegister,newFolderName=(fileNameToRegister=scope.expectedFileName||primaryFile.name,updateUploadStatus("Ensuring folder structure exists..."),fileService.generateAppFilename());updateUploadStatus("Creating new folder..."),fileService.createFolder("LOCAL_STATIC",newFolderName,"").then(()=>(scope.config.custom_theme_name=newFolderName,scope.$emit("folderCreated"),newFolderName)).catch(error=>{if(error.data?.detailedMessage?.includes("already exists"))return scope.$emit("folderCreated"),newFolderName;throw error}).then(actualThemeName=>(scope.config.custom_theme_name=actualThemeName,fileService.ensureThemeFolderExists(scope.uploadTargetType,actualThemeName,"answers").then(themePath=>{var folderPromises=[...new Set(validFiles.map(vf=>vf.folder).filter(Boolean))].map(folder=>fileService.ensureSubFolderExists(scope.uploadTargetType,themePath,folder));return $q.all(folderPromises).then(()=>themePath)}))).then(themePath=>{updateUploadStatus(`Uploading ${validFiles.length} file(s)...`);var uploadPromises=validFiles.map(({file,folder},index)=>{let fileForUpload=file;return 0!==index||scope.expectedFileName||(fileForUpload=new File([file],fileNameToRegister,{type:file.type})),fileService.uploadFile(scope.uploadTargetType,folder?themePath+"/"+folder:themePath,fileForUpload)});return $q.all(uploadPromises)}).then(results=>{scope.uploadSuccess=!0,updateUploadStatus("Upload successful!"),scope.config[scope.configProperty]=fileNameToRegister,refreshComponentState(),scope.$emit("imageUploaded",{configProperty:scope.configProperty,fileName:fileNameToRegister,themeName:getThemeName()}),scope.onUploadComplete&&scope.onUploadComplete({success:!0,results:results}),hideMessageAfterDelay()}).catch(error=>{scope.uploadSuccess=!1,updateUploadStatus("Upload failed: "+(error.data?.detailedMessage||error.message||"Unknown error")),scope.onUploadComplete&&scope.onUploadComplete({success:!1,error:error})}).finally(()=>{scope.isUploading=!1})}}(validFiles,getThemeName()),fileInputElement.value=null)}},scope.removeFile=function(fileNameToRemove){var file=scope.uploadedFiles.find(f=>f.name===fileNameToRemove);file&&confirm(`Are you sure you want to delete "${fileNameToRemove}"?`)&&(scope.isUploading=!0,updateUploadStatus(`Deleting ${fileNameToRemove}...`),fileService.deleteFile(scope.uploadTargetType,file.path).then(()=>{scope.uploadSuccess=!0,updateUploadStatus(`"${fileNameToRemove}" deleted.`),refreshComponentState(),scope.$emit("imageDeleted",{configProperty:scope.configProperty,fileName:fileNameToRemove,themeName:getThemeName()}),scope.onUploadComplete&&scope.onUploadComplete({success:!0,deletedFileName:fileNameToRemove}),hideMessageAfterDelay()}).catch(error=>{scope.uploadSuccess=!1,updateUploadStatus("Error deleting file: "+(error.message||"Unknown error"))}).finally(()=>{scope.isUploading=!1}))},scope.clearMessages=clearMessages,scope.$watch("config.custom_theme_name",function(newThemeName,oldThemeName){newThemeName!==oldThemeName&&refreshComponentState(!0)}),function initializeComponent(){isInitialized||(!function setupDragAndDrop(){let dropArea=element.find(".drag-drop-area");dropArea.on("dragover dragenter",e=>{e.preventDefault(),scope.isDragOver||scope.$apply(()=>scope.isDragOver=!0)}),dropArea.on("dragleave drop",e=>{e.preventDefault(),scope.isDragOver&&scope.$apply(()=>scope.isDragOver=!1)}),dropArea.on("drop",e=>scope.handleFileSelect(e.originalEvent.dataTransfer.files)),element.on("$destroy",()=>dropArea.off("dragover dragenter dragleave drop"))}(),refreshComponentState(),isInitialized=!0)}(),scope.$on("imageSelectedFromSelector",function(event,data){data.configProperty===scope.configProperty&&$timeout(function(){refreshComponentState(!0)},100)})}}}]),llmApp.directive("customToggleSwitch",["$timeout","DescParamsService","PLUGIN_PATHS",function($timeout,DescParamsService,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"custom-toggle-switch.html",scope:{configProperty:"@?",elementId:"@",config:"=",labelText:"@",descriptionText:"@?",clearArrayName:"@?",inputId:"@",customModel:"=?",disabled:"=?",disabledText:"@"},controller:["$scope",function($scope){let useConfigProperty=$scope.configProperty&&""!==$scope.configProperty.trim();$scope.internalModel=useConfigProperty?$scope.config[$scope.configProperty]||!1:void 0!==$scope.customModel&&$scope.customModel,$scope.$watch("internalModel",function(newValue,oldValue){newValue!==oldValue&&(useConfigProperty?$scope.config[$scope.configProperty]=newValue:($scope.customModel=newValue,!0===oldValue&&!1===newValue&&$scope.clearArrayName&&$scope.config&&$scope.config[$scope.clearArrayName]&&($scope.config[$scope.clearArrayName]=[])))}),useConfigProperty?$scope.$watch(function(){return $scope.config[$scope.configProperty]},function(newValue){$scope.internalModel=newValue}):$scope.$watch("customModel",function(newValue){$scope.internalModel=newValue})}]}}]),llmApp.directive("datasetConnectionSelector",["PythonService","SharedPromiseService","ParamsHelperService","PLUGIN_PATHS",function(PythonService,SharedPromiseService,ParamsHelperService,PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",formName:"@",infoText:"@",labelText:"@",configProperty:"@",context:"@",onSuccess:"&",onDatasetCreated:"&"},templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"dataset-connection-selector-template.html",controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isConnectionDropdownOpen=!1,$scope.isDropdownHovered=!1,$scope.connectionFilter="",$scope.connections=[],$scope.connectionsByType={},$scope.selectedConnectionObj=null,$scope.datasetNameInput="",$scope.showTooltip=!1,$scope.filterActive=!1,$scope.isConnectionFocused=!1;var connectionBlurTimeout=null;$scope.isNameInputFocused=!1;let projectKey=$stateParams.projectKey;$scope.initConnectionData=function(){ParamsHelperService.do({parameterName:"connection_selector"},$scope.config,{},{}).then(function(data){data&&data.choices?($scope.connectionsByType={},$scope.connections=[],Object.keys(data.choices).forEach(function(connType){$scope.connectionsByType[connType]=[],data.choices[connType].forEach(function(connName){connName={id:connName,connectionName:connName,connectionDisplayName:connName,connectionType:connType,isHovered:!1};$scope.connections.push(connName),$scope.connectionsByType[connType].push(connName)})}),0<$scope.connections.length?$scope.selectedConnectionObj?$scope.connectionFilter&&$scope.connectionFilter===$scope.selectedConnectionObj.connectionDisplayName||($scope.connectionFilter=$scope.selectedConnectionObj.connectionDisplayName):($scope.selectedConnectionObj=$scope.connections[0],$scope.connectionFilter=$scope.selectedConnectionObj.connectionDisplayName):($scope.selectedConnectionObj=null,$scope.connectionFilter="")):($scope.connections=[],$scope.connectionsByType={})},function(error){$scope.connections=[],$scope.connectionsByType={}})};function connectionDocumentClickHandler(event){$scope.isConnectionDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){$scope.closeConnectionDropdownAndRevertText()})}$scope.closeConnectionDropdownAndRevertText=function(){$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler),$scope.selectedConnectionObj&&($scope.connectionFilter=$scope.selectedConnectionObj.connectionDisplayName),$scope.filterActive=!1},$scope.openConnectionDropdown=function(clearFilterOnOpen){connectionBlurTimeout&&$timeout.cancel(connectionBlurTimeout),$scope.isConnectionDropdownOpen?$scope.closeConnectionDropdownAndRevertText():(clearFilterOnOpen&&($scope.connectionFilter=""),$scope.isConnectionDropdownOpen=!0,$scope.filterActive=!1,$timeout(function(){angular.element(document).on("click",connectionDocumentClickHandler)},0))},$scope.selectConnection=function(connection){connectionBlurTimeout&&$timeout.cancel(connectionBlurTimeout),$scope.selectedConnectionObj=connection,$scope.connectionFilter=connection.connectionDisplayName,$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler)},$scope.clearConnectionSelection=function(){$scope.connectionFilter="",$scope.selectedConnectionObj=null,$scope.openConnectionDropdown(!0),$element[0].querySelector('input[ng-model="connectionFilter"]').focus()},$scope.handleConnectionInputChange=function(){$scope.selectedConnectionObj&&$scope.connectionFilter!==$scope.selectedConnectionObj.connectionDisplayName&&($scope.selectedConnectionObj=null),$scope.filterActive=!0,!$scope.isConnectionDropdownOpen&&$scope.connectionFilter&&$scope.openConnectionDropdown(!1)},$scope.handleConnectionInputBlur=function(){connectionBlurTimeout=$timeout(function(){$scope.isConnectionDropdownOpen&&$scope.closeConnectionDropdownAndRevertText()},200)},$scope.handleInputFocus=function(){$scope.isConnectionDropdownOpen||$scope.openConnectionDropdown(!1)},$scope.connectionMatchesFilter=function(connection){var filter;return!$scope.filterActive||!$scope.connectionFilter||(filter=$scope.connectionFilter.toLowerCase(),connection.connectionDisplayName.toLowerCase().includes(filter))||connection.connectionType.toLowerCase().includes(filter)},$scope.typeHasMatchingConnections=function(type){return!!$scope.connectionsByType[type]&&$scope.connectionsByType[type].some(c=>$scope.connectionMatchesFilter(c))},$scope.hasMatchingConnections=function(){return 0!==$scope.connections.length&&(!$scope.connectionFilter||$scope.connections.some(c=>$scope.connectionMatchesFilter(c)))},$scope.createDataset=function(){var payload;$scope.datasetNameInput&&$scope.selectedConnectionObj&&(payload={parameterName:"create_dataset",projectKey:projectKey,arguments:{name:$scope.datasetNameInput,connection:$scope.selectedConnectionObj}},ParamsHelperService.do(payload).then(function(response){response.success&&($scope.config[$scope.configProperty]=response.dataset.datasetName,$scope.datasetNameInput="",$scope.$emit("datasetCreated"),$timeout(function(){$scope.onDatasetCreated&&$scope.onDatasetCreated(),$scope.onSuccess&&$scope.onSuccess({dataset:response.dataset,property:$scope.configProperty})}))}))},$scope.resetForm=function(){$scope.datasetNameInput="",$scope.selectedConnectionObj=null,$scope.connectionFilter="",$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,$scope.isNameInputFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler)},$scope.$on("$destroy",function(){$scope.resetForm(),angular.element(document).off("click",connectionDocumentClickHandler)}),$scope.initConnectionData()}]}}]),llmApp.directive("datasetSelector",["PythonService","SharedPromiseService","ParamsHelperService","SharedDataService","PLUGIN_PATHS",function(PythonService,SharedPromiseService,ParamsHelperService,SharedDataService,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"dataset-selector-template.html",scope:{config:"=",formName:"=",labelText:"@",fieldRequired:"=",configProperty:"@",context:"@"},controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isDropdownHovered=!1,$scope.isDatasetDropdownOpen=!1,$scope.datasetFilter="",$scope.datasets=[],$scope.datasetsByType={},$scope.selectedDataset=null,$scope.filterActive=!1;var blurTimeout=null;let payload={projectKey:$stateParams.projectKey,parameterName:"datasets_names"};function documentClickHandler(event){$scope.isDatasetDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){$scope.closeDropdownAndRevertText()})}var dataRefreshNeededListener=$scope.$on("dataNeedsRefresh",function(){ParamsHelperService.do(payload,$scope.config,{},{}).then(function(updatedData){$scope.initDatasetData()}).catch(function(error){console.error("ParamsHelperService.do failed to refresh datasets selector.",{payload:JSON.stringify(payload),message:error?.message,stack:error?.stack,error:error})})});$scope.$on("$destroy",function(){dataRefreshNeededListener()}),$scope.initDatasetData=function(){ParamsHelperService.do(payload,$scope.config,{},{}).then(function(data){var datasetName,foundDataset;data&&data.choices?($scope.datasetsByType={},$scope.datasets=[],Object.keys(data.choices).forEach(function(datasetType){$scope.datasetsByType[datasetType]=[],data.choices[datasetType].forEach(function(datasetName){datasetName={id:datasetName,datasetName:datasetName,datasetDisplayName:datasetName,datasetType:datasetType,isHovered:!1};$scope.datasets.push(datasetName),$scope.datasetsByType[datasetType].push(datasetName)})}),$scope.config[$scope.configProperty]&&(datasetName=$scope.config[$scope.configProperty],(foundDataset=$scope.datasets.find(function(d){return d.datasetName===datasetName}))?($scope.selectedDataset=foundDataset,$scope.datasetFilter=foundDataset.datasetDisplayName):($scope.config[$scope.configProperty]=null,$scope.selectedDataset=null,$scope.datasetFilter=""))):($scope.datasets=[],$scope.datasetsByType={})},function(error){$scope.datasets=[],$scope.datasetsByType={}})};$scope.closeDropdownAndRevertText=function(){$scope.isDatasetDropdownOpen=!1,angular.element(document).off("click",documentClickHandler),$scope.selectedDataset&&($scope.datasetFilter=$scope.selectedDataset.datasetDisplayName),$scope.filterActive=!1},$scope.openDatasetDropdown=function(clearFilterOnOpen){blurTimeout&&$timeout.cancel(blurTimeout),$scope.isDatasetDropdownOpen?$scope.closeDropdownAndRevertText():(clearFilterOnOpen&&($scope.datasetFilter=""),$scope.isDatasetDropdownOpen=!0,$scope.filterActive=!1,$timeout(function(){angular.element(document).on("click",documentClickHandler)},0))},$scope.selectDataset=function(dataset){blurTimeout&&$timeout.cancel(blurTimeout),$scope.selectedDataset=dataset,$scope.config[$scope.configProperty]=dataset.datasetName,$scope.datasetFilter=dataset.datasetDisplayName,$scope.isDatasetDropdownOpen=!1,angular.element(document).off("click",documentClickHandler)},$scope.clearSelection=function(){$scope.datasetFilter="",$scope.selectedDataset=null,$scope.config[$scope.configProperty]=null,$scope.openDatasetDropdown(),$element[0].querySelector("input").focus()},$scope.handleInputChange=function(){$scope.selectedDataset&&$scope.datasetFilter!==$scope.selectedDataset.datasetDisplayName&&($scope.selectedDataset=null,$scope.config[$scope.configProperty]=null),$scope.filterActive=!0,!$scope.isDatasetDropdownOpen&&$scope.datasetFilter&&$scope.openDatasetDropdown(!1)},$scope.handleInputBlur=function(){blurTimeout=$timeout(function(){$scope.isDatasetDropdownOpen&&$scope.closeDropdownAndRevertText()},200)},$scope.handleInputFocus=function(){$scope.isDatasetDropdownOpen||$scope.openDatasetDropdown(!1)},$scope.datasetMatchesFilter=function(dataset){var filter;return!$scope.filterActive||(filter=$scope.datasetFilter.toLowerCase(),dataset.datasetDisplayName.toLowerCase().includes(filter))||dataset.datasetType.toLowerCase().includes(filter)},$scope.typeHasMatchingDatasets=function(type){return!!$scope.datasetsByType[type]&&$scope.datasetsByType[type].some(d=>$scope.datasetMatchesFilter(d))},$scope.hasMatchingDatasets=function(){return 0!==$scope.datasets.length&&(!$scope.datasetFilter||$scope.datasets.some(d=>$scope.datasetMatchesFilter(d)))},$scope.initDatasetData()}]}}]),llmApp.directive("dndSortable",[function(){return{restrict:"A",scope:{dndList:"=dndSortable"},link:function(scope,element,attrs){var container,draggedItem,observer,itemSelector=attrs.dndSortableItemSelector;function getElementIndex(item){return Array.from(container.querySelectorAll(itemSelector)).indexOf(item)}itemSelector&&(container=element[0],draggedItem=null,container.addEventListener("dragstart",function(e){var sourceIndex,targetItem=e.target.closest(itemSelector);targetItem&&(sourceIndex=getElementIndex(draggedItem=targetItem),e.dataTransfer.setData("text/plain",sourceIndex),e.dataTransfer.effectAllowed="move",setTimeout(function(){draggedItem.classList.add("dragging"),draggedItem.style.opacity="0.5",scope.$apply(function(){scope.$parent.isDragging||(scope.$parent.isDragging={}),scope.$parent.isDragging[sourceIndex]=!0})},0))}),container.addEventListener("dragover",function(e){e.preventDefault(),e.dataTransfer.dropEffect="move";var rect,targetItem=e.target.closest(itemSelector);targetItem&&targetItem!==draggedItem&&(container.querySelectorAll(itemSelector).forEach(function(item){item.classList.remove("drop-before","drop-after")}),rect=targetItem.getBoundingClientRect(),e=e.clientY<rect.top+rect.height/2,targetItem.classList.add(e?"drop-before":"drop-after"))}),container.addEventListener("drop",function(e){var sourceIndex,targetIndex,targetElement,dropIndex;e.preventDefault(),draggedItem&&(sourceIndex=parseInt(e.dataTransfer.getData("text/plain")),targetElement=e.target.closest(itemSelector))&&(targetIndex=getElementIndex(targetElement),targetElement=targetElement.getBoundingClientRect(),dropIndex=e.clientY<targetElement.top+targetElement.height/2?targetIndex:targetIndex+1,scope.$apply(function(){!function moveItem(fromIndex,toIndex){var list;fromIndex!==toIndex&&(list=scope.dndList,fromIndex<toIndex&&toIndex--,fromIndex=list.splice(fromIndex,1)[0],list.splice(toIndex,0,fromIndex))}(sourceIndex,dropIndex)}))}),container.addEventListener("dragend",function(e){!function cleanupStyling(){container.querySelectorAll(itemSelector).forEach(function(item){item.classList.remove("drop-before","drop-after","dragging"),item.style.opacity="1"})}(),setTimeout(function(){scope.$apply(function(){scope.$parent.isDragging&&(scope.$parent.isDragging={})})},50),draggedItem=null}),(observer=new MutationObserver(function(mutations){mutations.forEach(function(mutation){mutation.addedNodes.forEach(function(node){1===node.nodeType&&node.matches(itemSelector)&&node.setAttribute("draggable","true")})})})).observe(container,{childList:!0}),function initializeDraggableItems(){container.querySelectorAll(itemSelector).forEach(function(item){item.setAttribute("draggable","true")})}(),scope.$on("$destroy",function(){observer.disconnect()}))}}}]),llmApp.directive("feedbackChoices",["DescParamsService","PLUGIN_PATHS",function(DescParamsService,PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",choicesArray:"@",description:"@",allowWrap:"<",width:"@",labelButton:"@"},templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"feedbackChoices.html",controller:["$scope",function($scope){$scope.isDragging={},$scope.config[$scope.choicesArray]||(DescParamsService.getDefaultValue($scope.choicesArray)?$scope.config[$scope.choicesArray]=DescParamsService.getDefaultValue($scope.choicesArray):$scope.config[$scope.choicesArray]=[]),$scope.addItem=function(){$scope.config[$scope.choicesArray]||($scope.config[$scope.choicesArray]=[]),$scope.config[$scope.choicesArray].push("")},$scope.removeItem=function(index){$scope.config[$scope.choicesArray].splice(index,1)}}]}}]),llmApp.directive("filtersMetadata",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"filters-metadata.html",scope:{config:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.isKnowledgeNameFocused=!1,void 0===$scope.config.knowledge_sources_filters&&($scope.config.knowledge_sources_filters=[]),void 0===$scope.config.knowledge_sources_displayed_metas&&($scope.config.knowledge_sources_displayed_metas=!1),void 0===$scope.config.knowledge_source_url&&($scope.config.knowledge_source_url=!0),void 0===$scope.config.knowledge_source_title&&($scope.config.knowledge_source_title=!0),void 0===$scope.config.knowledge_source_thumbnail&&($scope.config.knowledge_source_thumbnail=!1),$scope.isExpanded=!1,$scope.toggleExpand=function(){$scope.isExpanded=!$scope.isExpanded}}]}}]),llmApp.directive("folderMultiSelector",["PythonService","ParamsHelperService","PLUGIN_PATHS",function(PythonService,ParamsHelperService,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"folder-multiselect-template.html",scope:{config:"=",formName:"@",labelText:"@",configProperty:"@",description:"@",folderChoices:"=?",triggerParameter:"=",width:"@?",maxHeightThreshold:"@?"},controller:["$scope","$timeout",function($scope,$timeout){$scope.maxHeightThreshold=$scope.maxHeightThreshold||82,$scope.isDropdownOpen=!1,$scope.folders=[],$scope.config=$scope.config||{},$scope.selectedItems=[],$scope.showAllItems=!1,$scope.exceedsMaxHeight=!1,$scope.visibleItemCount=0,$scope.remainingItemCount=0,$scope.toggleShowAll=function(){$scope.showAllItems=!$scope.showAllItems},$scope.itemFilter="",$scope.getVisibleItems=function(){return $scope.selectedItems.length<=3||$scope.showAllItems?$scope.selectedItems:$scope.selectedItems.slice(0,3)};let projectKey=$stateParams.projectKey;function normalizeDataFormat(data){if(Array.isArray(data))return{General:data.map(item=>({value:item.value,label:item.label,type:"General"}))};if(data&&"object"==typeof data){let normalized={};return Object.keys(data).forEach(function(type){Array.isArray(data[type])&&(normalized[type]=data[type].map(item=>"string"==typeof item?{value:item,label:item,type:type}:item&&"object"==typeof item&&item.value&&item.label?{value:item.value,label:item.label,type:type}:null).filter(item=>null!==item))}),normalized}return{}}function initializeSelectedFolders(){var folderIds;$scope.selectedItems=[],$scope.config[$scope.configProperty]&&Array.isArray($scope.config[$scope.configProperty])?((folderIds=$scope.config[$scope.configProperty]).forEach(function(folderId){var foundFolder=$scope.folders.find(function(folder){return folder.value===folderId});foundFolder&&$scope.selectedItems.push(foundFolder)}),0<folderIds.length&&0===$scope.selectedItems.length&&($scope.config[$scope.configProperty]=[])):$scope.config[$scope.configProperty]||($scope.config[$scope.configProperty]=[]),checkContentHeight()}function checkContentHeight(){var retries=0;$timeout(function attemptMeasurement(){var container=document.getElementById($scope.configProperty+"-items-container");if(container){var children=container.children;if(0===children.length)retries<20&&$timeout(attemptMeasurement,100*++retries);else if(0===children[0].offsetHeight&&retries<20)$timeout(attemptMeasurement,100*++retries);else{var visibleCount=children.length;for(let i=0;i<children.length;i++){var item=children[i];if(item.offsetTop+item.offsetHeight>$scope.maxHeightThreshold){visibleCount=i;break}}$scope.visibleItemCount=visibleCount,$scope.exceedsMaxHeight=visibleCount<children.length,$scope.remainingItemCount=children.length-visibleCount,$scope.exceedsMaxHeight||($scope.showAllItems=!1)}}else retries<20&&$timeout(attemptMeasurement,100*++retries)},0)}function updateConfigValue(){$scope.config[$scope.configProperty]=$scope.selectedItems.map(function(item){return item.value})}$scope.initFolderData=function(){var normalizedData;$scope.folderChoices?(normalizedData=normalizeDataFormat($scope.folderChoices),$scope.foldersByType=normalizedData,$scope.folders=[],Object.keys($scope.foldersByType).forEach(function(type){$scope.folders=$scope.folders.concat($scope.foldersByType[type])}),initializeSelectedFolders()):(normalizedData={parameterName:$scope.configProperty,projectKey:projectKey},ParamsHelperService.do(normalizedData,$scope.config).then(function(data){data&&data.choices?(data=normalizeDataFormat(data.choices),$scope.foldersByType=data,$scope.folders=[],Object.keys($scope.foldersByType).forEach(function(type){$scope.folders=$scope.folders.concat($scope.foldersByType[type])}),initializeSelectedFolders()):($scope.foldersByType={},$scope.folders=[])},function(error){$scope.foldersByType={},$scope.folders=[]}))},$scope.typeHasMatchingFolders=type=>0<$scope.foldersByType[type]?.length,$scope.toggleDropdown=function(event){event&&event.stopPropagation(),$scope.isDropdownOpen=!$scope.isDropdownOpen,$scope.isDropdownOpen&&$timeout(function(){angular.element(document).one("click",function(){$scope.$apply(function(){$scope.isDropdownOpen=!1})})},0)},$scope.isItemSelected=function(item){return $scope.selectedItems.some(function(selectedItem){return selectedItem.value===item.value})},$scope.toggleItemSelection=function(item){$scope.isItemSelected(item)?$scope.removeItem(item):($scope.selectedItems.push(item),updateConfigValue())},$scope.removeItem=function(item,event){event&&event.stopPropagation(),$scope.selectedItems=$scope.selectedItems.filter(function(selectedItem){return selectedItem.value!==item.value}),updateConfigValue()},$scope.clearAllItems=function(){$scope.selectedItems=[],updateConfigValue(),checkContentHeight()},$scope.$watch("triggerParameter",function(newValue,oldValue){newValue!==oldValue&&$scope.initFolderData()},!0),$scope.$on("$destroy",function(){angular.element(window).off("resize")}),$scope.initFolderData(),$scope.$watch("selectedItems",function(newValue,oldValue){newValue!==oldValue&&checkContentHeight()},!0)}]}}]),llmApp.directive("folderSelector",["PythonService","ParamsHelperService","DescParamsService","customFileUploaderService","PLUGIN_PATHS","$stateParams",function(PythonService,ParamsHelperService,DescParamsService,customFileUploaderService,PLUGIN_PATHS,stateParams){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"folder-selector-template.html",scope:{config:"=",formName:"=",labelText:"@",fieldRequired:"=",configProperty:"@",description:"@",defaultValue:"@",folderChoices:"=?",customMargin:"@?",isLanguageMappingsArray:"=?",getChoicesFromPython:"@",writePermission:"@",triggerParameter:"=",validationMessage:"@"},link:function(scope){scope.config=scope.config||{}},controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isFolderDropdownOpen=!1,$scope.isDropdownHovered=!1,$scope.isFolderFocused=!1,$scope.isCreatingFolder=!1,$scope.folders=[],$scope.folderFilter="",$scope.selectedFolder=null,$scope.folderCreationError="",$scope.filterActive=!1;function setAndProcessFolders(rawChoices){let processedChoices;var languageMappings;if(processedChoices=$scope.isLanguageMappingsArray?(languageMappings=$scope.isLanguageMappingsArray,Array.isArray(languageMappings)?languageMappings.filter(mapping=>mapping&&mapping.to).map(mapping=>({label:mapping.to,value:mapping.to})):[]):(choices=>{if(!Array.isArray(choices))return[];if("custom_theme_name"===$scope.configProperty&&$scope.config){let defaultFolder={value:"",label:"Default customization"};var defaultItem=(choices=choices.some(f=>f.value===defaultFolder.value&&f.label===defaultFolder.label)?choices:[...choices,defaultFolder]).find(choice=>"Default customization"===choice.label),otherItems=choices.filter(choice=>"Default customization"!==choice.label);return otherItems.sort((a,b)=>a.label.localeCompare(b.label)),defaultItem?[defaultItem,...otherItems]:otherItems}return choices.filter(choice=>""!==choice.value&&"none"!==choice.label.toLowerCase())})(rawChoices),$scope.folderHoverStates=processedChoices.reduce((acc,folder)=>(acc[folder.value]=!1,acc),{}),$scope.folders=processedChoices,"custom_theme_name"!==$scope.configProperty||!$scope.config||"Default customization"!==$scope.config.custom_theme_name&&$scope.config.custom_theme_name){let folderId=$scope.config[$scope.configProperty];folderId?(languageMappings=$scope.folders.find(f=>f.value===folderId))?$scope.selectFolder(languageMappings):$scope.defaultValue?$scope.selectFolder({label:$scope.defaultValue,value:$scope.defaultValue}):$scope.selectFolder(null):$scope.selectFolder(null)}else{let defaultFolder={value:"",label:"Default customization"};$scope.folders.some(f=>f.value===defaultFolder.value&&f.label===defaultFolder.label)||($scope.folders=[...$scope.folders,defaultFolder]),void($scope.selectedFolder&&$scope.selectedFolder.value===defaultFolder.value||$scope.selectFolder(defaultFolder))}}function removeDocumentClickHandler(){angular.element(document).off("click",handleDocumentClick)}function initialize(){var choices;"false"===$scope.getChoicesFromPython?(choices=DescParamsService.getSelectChoices($scope.configProperty)||[],setAndProcessFolders(choices)):$scope.isLanguageMappingsArray?setAndProcessFolders($scope.isLanguageMappingsArray):$scope.writePermission?customFileUploaderService.listSubFolders().then(response=>setAndProcessFolders(response)).catch(error=>{setAndProcessFolders([])}):(choices={parameterName:$scope.configProperty,projectKey:projectKey},ParamsHelperService.do(choices,$scope.config).then(data=>setAndProcessFolders(data.choices||[])).catch(error=>{setAndProcessFolders([])}))}let folderBlurTimeout=null,projectKey=$stateParams.projectKey,handleDocumentClick=function(event){$scope.isFolderDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(()=>closeFolderDropdownAndRevertText())},closeFolderDropdownAndRevertText=function(){$scope.isFolderDropdownOpen&&($scope.isFolderDropdownOpen=!1,$scope.isFolderFocused=!1,removeDocumentClickHandler(),$scope.folderFilter=$scope.selectedFolder?$scope.selectedFolder.label:"",$scope.filterActive=!1)};$scope.openFolderDropdown=function(clearFilter){folderBlurTimeout&&$timeout.cancel(folderBlurTimeout),$scope.isFolderDropdownOpen?closeFolderDropdownAndRevertText():(clearFilter&&($scope.folderFilter=""),$scope.isFolderDropdownOpen||($scope.isFolderDropdownOpen=!0,$scope.filterActive=!1,$timeout(()=>angular.element(document).on("click",handleDocumentClick),0)))},$scope.selectFolder=function(folder){folderBlurTimeout&&$timeout.cancel(folderBlurTimeout),$scope.selectedFolder=folder,$scope.config[$scope.configProperty]=folder?folder.value:null,$scope.folderFilter=folder?folder.label:"",$scope.isFolderDropdownOpen=!1,$scope.isFolderFocused=!1,removeDocumentClickHandler()},$scope.clearFolderSelection=function(){$scope.selectFolder(null),$scope.openFolderDropdown(null,!1),$element[0].querySelector("input").focus()},$scope.createNewFolder=function(){if(!$scope.isCreatingFolder){$scope.isCreatingFolder=!0,$scope.folderCreationError="";let newFolderName=customFileUploaderService.generateAppFilename();$scope.folders.some(f=>f.label.toLowerCase()===newFolderName.toLowerCase())?($timeout(()=>{$scope.folderCreationError="A folder with this name already exists.",$scope.isCreatingFolder=!1},0),$timeout(()=>{$scope.folderCreationError=null},5e3)):customFileUploaderService.createFolder("LOCAL_STATIC",newFolderName,"").then(function(newFolder){$scope.$applyAsync(()=>{$scope.folders.push(newFolder),$scope.selectFolder(newFolder)})}).catch(function(error){$scope.folderCreationError="Failed to create folder: "+(error.data?.detailedMessage||"Unknown error")}).finally(function(){$scope.isCreatingFolder=!1})}},$scope.handleFolderInputChange=function(){$scope.selectedFolder&&$scope.folderFilter!==$scope.selectedFolder.label&&($scope.selectedFolder=null,$scope.config[$scope.configProperty]=null),$scope.filterActive=!0,!$scope.isFolderDropdownOpen&&$scope.folderFilter&&$scope.openFolderDropdown(null,!1)},$scope.handleFolderInputBlur=function(){folderBlurTimeout=$timeout(()=>{closeFolderDropdownAndRevertText()},200)},$scope.handleInputFocus=function(){$scope.isFolderDropdownOpen||$scope.openFolderDropdown(!1)},$scope.folderFilterFn=function(folder){return!$scope.filterActive||!!folder?.label&&(!$scope.folderFilter||folder.label.toLowerCase().includes($scope.folderFilter.toLowerCase()))};$scope.isLanguageMappingsArray&&$scope.$watch("isLanguageMappingsArray",function(newVal,oldVal){angular.equals(newVal,oldVal)||setAndProcessFolders(newVal)},!0),$scope.$on("$destroy",function(){removeDocumentClickHandler(),folderBlurTimeout&&$timeout.cancel(folderBlurTimeout)}),initialize(),$scope.$on("folderRefreshRequested",function(){initialize()}),$scope.$watch("triggerParameter",function(newValue,oldValue){newValue!==oldValue&&initialize()},!0)}]}}]),llmApp.directive("imageSelector",["customFileUploaderService","$timeout","PLUGIN_PATHS",function(customFileUploaderService,$timeout,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"image-selector.html",scope:{config:"=",configProperty:"@",labelText:"@",onImageSelected:"&?"},link:function(scope,element){function getThemeName(){return scope.config?.custom_theme_name||"Default customization"}function updateScrollButtons(){var carousel=element.find("#imageCarousel")[0];carousel&&(scope.canScrollLeft=0<carousel.scrollLeft,scope.canScrollRight=carousel.scrollLeft<carousel.scrollWidth-carousel.clientWidth)}function updateScrollDots(){var carousel=element.find("#imageCarousel")[0];if(!carousel||scope.availableImages.length<=4)scope.scrollDots=[];else{var scrollLeft=carousel.scrollLeft,carousel=carousel.scrollWidth-carousel.clientWidth;if(carousel<=0)scope.scrollDots=[];else{var numDots=Math.min(5,Math.max(3,Math.ceil(scope.availableImages.length/3))),segmentSize=carousel/(numDots-1);let activeDotIndex=0;for(let i=0;i<numDots;i++){var segmentStart=i*segmentSize,segmentEnd=(i+1)*segmentSize;if(segmentStart<=scrollLeft&&(scrollLeft<segmentEnd||i===numDots-1)){activeDotIndex=i;break}}scope.scrollDots=[];for(let i=0;i<numDots;i++)scope.scrollDots.push({active:i===activeDotIndex,index:i})}}}function refreshAvailableImages(silent=!1){let themeName=getThemeName();themeName&&"Default customization"!==themeName?(silent||(scope.isLoading=!0),customFileUploaderService.fetchUploadedFiles("LOCAL_STATIC").then(response=>{response=customFileUploaderService.getAllFilesForTheme(response.data,themeName).filter(file=>{var pathParts=file.path.split("/");return 4<=pathParts.length&&"answers"===pathParts[0]&&pathParts[1]===themeName&&"images"===pathParts[2]&&customFileUploaderService.isImageFileByName(file.name)}).map(file=>({name:file.name,url:window.location.origin+`/local/static/${file.path}?v=`+(new Date).getTime(),path:file.path}));scope.availableImages=response,$timeout(function(){updateScrollButtons(),updateScrollDots()},100)}).catch(error=>{scope.availableImages=[]}).finally(()=>{scope.isLoading=!1})):(scope.availableImages=[],scope.isLoading=!1)}scope.availableImages=[],scope.isLoading=!1,scope.selectedImageName=null,scope.canScrollLeft=!1,scope.canScrollRight=!1,scope.scrollDots=[],scope.shouldShowSelector=function(){var themeName=getThemeName();return!(!themeName||"Default customization"===themeName||!scope.isLoading&&0===scope.availableImages.length)},scope.scrollLeft=function(){var carousel=element.find("#imageCarousel")[0];carousel&&(carousel.scrollLeft-=120,$timeout(function(){updateScrollButtons(),updateScrollDots()},100))},scope.scrollRight=function(){var carousel=element.find("#imageCarousel")[0];carousel&&(carousel.scrollLeft+=120,$timeout(function(){updateScrollButtons(),updateScrollDots()},100))},scope.selectImage=function(image){scope.selectedImageName=image.name,scope.config[scope.configProperty]=image.name,scope.onImageSelected&&scope.onImageSelected({selectedImage:image,configProperty:scope.configProperty})},scope.isImageSelected=function(image){return scope.config[scope.configProperty]===image.name},scope.$watch("config.custom_theme_name",function(newTheme,oldTheme){newTheme!==oldTheme&&refreshAvailableImages()}),scope.$on("refreshImageSelector",function(event,data){var currentTheme=getThemeName();data.themeName&&data.themeName!==currentTheme||$timeout(function(){refreshAvailableImages(!0)},500)}),scope.$on("folderRefreshRequested",function(){$timeout(function(){refreshAvailableImages()},1e3)}),function initialize(){refreshAvailableImages();var currentValue=scope.config[scope.configProperty];currentValue&&(scope.selectedImageName=currentValue),$timeout(function(){var carousel=element.find("#imageCarousel")[0];carousel&&carousel.addEventListener("scroll",function(){scope.$apply(function(){updateScrollButtons(),updateScrollDots()})})},500)}()}}}]),llmApp.directive("inputWithLabel",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"input-with-label.html",scope:{config:"=",labelText:"@",configProperty:"@",initialWidth:"@?",initialHeight:"@?",placeholder:"@?",description:"@",fieldRequired:"=",formName:"=",customMargin:"@?"},link:function(scope,element,attrs){scope.initialWidth=scope.initialWidth||"100%",scope.initialHeight=scope.initialHeight||"80px";element=element.find("textarea")[0];element&&(element.style.width=scope.initialWidth,element.style.height=scope.initialHeight)},controller:["$scope","$timeout",function($scope,$timeout){$scope.config[$scope.configProperty]||($scope.config[$scope.configProperty]=""),$scope.$watch("config."+$scope.configProperty,function(newVal){void 0===newVal&&($scope.config[$scope.configProperty]="")}),$scope.isFieldEmpty=function(){return null==$scope.config[$scope.configProperty]||""===$scope.config[$scope.configProperty].trim()}}]}}]),llmApp.directive("languageMappings",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",mappingsArray:"@",description:"@",labelText:"@",buttonLabel:"@",keyPlaceholder:"@",valuePlaceholder:"@"},templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"language-mappings.html",link:function(scope,element){scope.languageMappings||(scope.languageMappings=scope.config&&scope.config[scope.mappingsArray]?scope.config[scope.mappingsArray]:[]),scope.isArray=Array.isArray(scope.languageMappings);var container=element[0].querySelector(".language-mappings-container"),draggedItem=null,draggedIndex=null;function initDragHandlers(){container.querySelectorAll(".language-mapping-item").forEach(function(item,index){item.addEventListener("dragstart",function(e){draggedItem=item,draggedIndex=index,e.dataTransfer.setData("text/plain",index),e.dataTransfer.effectAllowed="move",setTimeout(function(){item.classList.add("dragging"),item.style.opacity="0.5"},0)}),item.addEventListener("dragend",function(){cleanupStyling(),draggedIndex=draggedItem=null}),item.addEventListener("dragover",function(e){var rect;e.preventDefault(),e.dataTransfer.dropEffect="move",item!==draggedItem&&(function cleanupIndicators(){container.querySelectorAll(".language-mapping-item").forEach(function(item){item.classList.remove("drop-before"),item.classList.remove("drop-after")})}(),rect=item.getBoundingClientRect(),e.clientY<rect.top+rect.height/2?item.classList.add("drop-before"):item.classList.add("drop-after"))}),item.addEventListener("drop",function(e){var sourceIndex,targetIndex,rect,dropIndex;e.preventDefault(),e.stopPropagation(),null!==draggedItem&&(sourceIndex=draggedIndex,targetIndex=index,rect=item.getBoundingClientRect(),dropIndex=e.clientY<rect.top+rect.height/2?targetIndex:targetIndex+1,scope.$applyAsync(function(){moveItem(sourceIndex,dropIndex)}),cleanupStyling())})})}function cleanupStyling(){container.querySelectorAll(".language-mapping-item").forEach(function(item){item.classList.remove("drop-before"),item.classList.remove("drop-after"),item.classList.remove("dragging"),item.style.opacity="1"})}function moveItem(fromIndex,toIndex){var itemToMove,newMappings;fromIndex!==toIndex&&(itemToMove=scope.languageMappings[fromIndex],(newMappings=scope.languageMappings.slice()).splice(fromIndex,1),fromIndex<toIndex&&toIndex--,newMappings.splice(toIndex,0,itemToMove),scope.languageMappings=newMappings)}scope.$watch("config[mappingsArray]",function(newValue){newValue&&Array.isArray(newValue)&&(scope.languageMappings=newValue)}),container.addEventListener("dragover",function(e){e.preventDefault(),e.dataTransfer.dropEffect="move"}),container.addEventListener("drop",function(e){e.target===container&&(e.preventDefault(),e.stopPropagation(),null!==draggedItem)&&(scope.$applyAsync(function(){moveItem(draggedIndex,scope.languageMappings.length)}),cleanupStyling())}),scope.$watchCollection("languageMappings",function(){setTimeout(function(){initDragHandlers()},0)}),setTimeout(function(){initDragHandlers()},0)},controller:["$scope",function($scope){$scope.addMapping=function(){$scope.isArray?$scope.languageMappings.push({from:"",to:""}):$scope.languageMappings[""]=""},$scope.removeMapping=function(indexOrKey){$scope.isArray?$scope.languageMappings.splice(indexOrKey,1):delete $scope.languageMappings[indexOrKey]},$scope.updateKey=function(oldKey,newKey){var value;oldKey!==newKey&&(newKey&&""!==newKey.trim()?(newKey=newKey.trim(),$scope.languageMappings.hasOwnProperty(newKey)&&newKey!==oldKey||(value=$scope.languageMappings[oldKey],delete $scope.languageMappings[oldKey],$scope.languageMappings[newKey]=value)):""!==oldKey&&delete $scope.languageMappings[oldKey])}}]}}]),llmApp.directive("numberInputField",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",scope:{modelValue:"=",labelText:"@",minValue:"@",maxValue:"@",placeholder:"@",zeroMessage:"@",warningMessage:"@",description:"@",numberType:"@",subLabel:"@"},templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"number-input-template.html",controller:["$scope","$interval",function($scope,$interval){var intervalPromise;$scope.inputFocused=!1,$scope.minValueNum=parseFloat($scope.minValue)||0,$scope.maxValueNum=parseFloat($scope.maxValue)||100,$scope.numberType||($scope.numberType="DOUBLE"),$scope.step="INT"===$scope.numberType?"1":"any",null!=$scope.modelValue&&!isNaN($scope.modelValue)||($scope.modelValue="INT"===$scope.numberType?Math.round($scope.minValueNum):$scope.minValueNum),$scope.incrementValue=function(){var step="INT"===$scope.numberType?1:.1,step=(parseFloat($scope.modelValue)||0)+step;(!$scope.maxValue||step<=parseFloat($scope.maxValue))&&($scope.modelValue="INT"===$scope.numberType?Math.round(step):parseFloat(step.toFixed(1)))},$scope.decrementValue=function(){var step="INT"===$scope.numberType?1:.1,step=(parseFloat($scope.modelValue)||0)-step;(!$scope.minValue||step>=parseFloat($scope.minValue))&&($scope.modelValue="INT"===$scope.numberType?Math.round(step):parseFloat(step.toFixed(1)))},$scope.startIncrementing=function(){$scope.stopActions(),$scope.incrementValue(),intervalPromise=$interval($scope.incrementValue,100)},$scope.startDecrementing=function(){$scope.stopActions(),$scope.decrementValue(),intervalPromise=$interval($scope.decrementValue,100)},$scope.stopActions=function(){$interval.cancel(intervalPromise)},$scope.onInputChange=function(){$timeout(function(){"INT"===$scope.numberType&&null!=$scope.modelValue&&($scope.modelValue=Math.round(parseFloat($scope.modelValue)))},0)},$scope.$watch("modelValue",function(newVal){var newVal=parseFloat(newVal),belowMin=$scope.minValue&&newVal<parseFloat($scope.minValue),aboveMax=$scope.maxValue&&newVal>parseFloat($scope.maxValue),newVal=isNaN(newVal);$scope.invalidInput=!!(newVal||belowMin||aboveMax)}),$scope.$on("$destroy",function(){$scope.stopActions()})}]}}]),llmApp.directive("sqlRetrievalConnectionSelect",["PythonService","SharedPromiseService","ParamsHelperService","PLUGIN_PATHS",function(PythonService,SharedPromiseService,ParamsHelperService,PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",formName:"=",infoText:"@",labelText:"@",configProperty:"@",context:"@",onSuccess:"&",onDatasetCreated:"&",fieldRequired:"="},templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"sql-retrieval-connection-select-template.html",controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isConnectionDropdownOpen=!1,$scope.isDropdownHovered=!1,$scope.connectionFilter="",$scope.connections=[],$scope.connectionsByType={},$scope.selectedConnectionObj=null,$scope.filterActive=!1,$scope.isConnectionFocused=!1;function connectionDocumentClickHandler(event){$scope.isConnectionDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){$scope.closeConnectionDropdownAndRevertText()})}let connectionBlurTimeout=null;$scope.isNameInputFocused=!1,$scope.initConnectionData=function(){ParamsHelperService.do({parameterName:"sql_retrieval_connection"},$scope.config,{},{}).then(function(data){var connectionName,foundConnection;data&&data.choices?($scope.connectionsByType={},$scope.connections=[],Object.keys(data.choices).forEach(function(connType){$scope.connectionsByType[connType]=[],data.choices[connType].forEach(function(connName){connName={id:connName,connectionName:connName,connectionDisplayName:connName,connectionType:connType,isHovered:!1};$scope.connections.push(connName),$scope.connectionsByType[connType].push(connName)})}),$scope.config[$scope.configProperty]&&(connectionName=$scope.config[$scope.configProperty],(foundConnection=$scope.connections.find(function(d){return d.connectionName===connectionName}))?($scope.selectedConnectionObj=foundConnection,$scope.connectionFilter=foundConnection.connectionDisplayName):($scope.config[$scope.configProperty]=null,$scope.selectedConnectionObj=null,$scope.connectionFilter=""))):($scope.connections=[],$scope.connectionsByType={})},function(error){$scope.connections=[],$scope.connectionsByType={}})};$scope.closeConnectionDropdownAndRevertText=function(){$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler),$scope.selectedConnectionObj?$scope.connectionFilter=$scope.selectedConnectionObj.connectionDisplayName:$scope.connectionFilter="",$scope.filterActive=!1},$scope.openConnectionDropdown=function(clearFilterOnOpen){connectionBlurTimeout&&$timeout.cancel(connectionBlurTimeout),$scope.isConnectionDropdownOpen||(clearFilterOnOpen&&($scope.connectionFilter=""),$scope.isConnectionDropdownOpen=!0,$scope.filterActive=!1,$timeout(function(){angular.element(document).on("click",connectionDocumentClickHandler)},0))},$scope.selectConnection=function(connection){connectionBlurTimeout&&$timeout.cancel(connectionBlurTimeout),$scope.selectedConnectionObj=connection,$scope.config[$scope.configProperty]=connection.connectionName,$scope.connectionFilter=connection.connectionDisplayName,$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler)},$scope.clearConnectionSelection=function(){$scope.connectionFilter="",$scope.selectedConnectionObj=null,$scope.config[$scope.configProperty]=null,$scope.openConnectionDropdown(!0),$element[0].querySelector('input[ng-model="connectionFilter"]').focus()},$scope.handleConnectionInputChange=function(){$scope.selectedConnectionObj&&$scope.connectionFilter!==$scope.selectedConnectionObj.connectionDisplayName&&($scope.selectedConnectionObj=null,$scope.config[$scope.configProperty]=null),$scope.filterActive=!0,!$scope.isConnectionDropdownOpen&&$scope.connectionFilter&&$scope.openConnectionDropdown(!1)},$scope.handleInputFocus=function(){$scope.isConnectionDropdownOpen||$scope.openConnectionDropdown(!1)},$scope.handleConnectionInputBlur=function(){connectionBlurTimeout=$timeout(function(){$scope.isConnectionDropdownOpen&&$scope.closeConnectionDropdownAndRevertText()},200)},$scope.connectionMatchesFilter=function(connection){var filter;return!$scope.filterActive||!$scope.connectionFilter||(filter=$scope.connectionFilter.toLowerCase(),connection.connectionDisplayName.toLowerCase().includes(filter))||connection.connectionType.toLowerCase().includes(filter)},$scope.typeHasMatchingConnections=function(type){return!!$scope.connectionsByType[type]&&$scope.connectionsByType[type].some(c=>$scope.connectionMatchesFilter(c))},$scope.hasMatchingConnections=function(){return 0!==$scope.connections.length&&(!$scope.connectionFilter||$scope.connections.some(c=>$scope.connectionMatchesFilter(c)))},$scope.resetForm=function(){$scope.datasetNameInput="",$scope.selectedConnectionObj=null,$scope.connectionFilter="",$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,$scope.isNameInputFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler)},$scope.$on("$destroy",function(){$scope.resetForm(),angular.element(document).off("click",connectionDocumentClickHandler)}),$scope.initConnectionData()}]}}]),llmApp.directive("uniqueLlmSelector",["PythonService","ParamsHelperService","PLUGIN_PATHS","$stateParams",function(PythonService,ParamsHelperService,PLUGIN_PATHS,stateParams){return{restrict:"E",templateUrl:PLUGIN_PATHS.DOCUMENT_QA+"llm-selector-template.html",scope:{config:"=",formName:"=",labelText:"@",fieldRequired:"=",configProperty:"@",context:"@",description:"@"},controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isDropdownHovered=!1,$scope.isLLMDropdownOpen=!1,$scope.llmFilter="",$scope.llms=[],$scope.llmsByType={},$scope.selectedLLM=null,$scope.filterActive=!1,$scope.showCopyTooltip=!1,$scope.isLLMFocused=!1;var llmBlurTimeout=null;$scope.selectedLLM=null;let projectKey=$stateParams.projectKey;$scope.copyLLMValue=function(){if($scope.selectedLLM&&$scope.selectedLLM.llmId){var textArea=document.createElement("textarea");textArea.value=$scope.selectedLLM.llmId,document.body.appendChild(textArea),textArea.select();try{document.execCommand("copy")}catch(err){}document.body.removeChild(textArea)}},$scope.initLLMData=function(){var llmParam=$scope.configProperty;let purpose="GENERIC_COMPLETION",typesToExclude=[];"image_generation_llm_id"===llmParam&&(purpose="IMAGE_GENERATION"),["title_llm_id","json_decision_llm_id"].includes(llmParam)&&(typesToExclude=["SAVED_MODEL_AGENT","RETRIEVAL_AUGMENTED"]);llmParam={parameterName:llmParam,projectKey:projectKey,purpose:purpose,typesToExclude:typesToExclude};ParamsHelperService.do(llmParam,$scope.config,{},{}).then(function(data){var configProp,llmId,foundLLM;data&&data.choices?($scope.llmsByType={},$scope.llms=[],Object.keys(data.choices).forEach(function(llmType){$scope.llmsByType[llmType]=[],data.choices[llmType].forEach(function(llm){llm={id:llm.value,llmId:llm.value,llmDisplayName:llm.label,llmType:llmType,isHovered:!1};$scope.llms.push(llm),$scope.llmsByType[llmType].push(llm)})}),configProp=$scope.configProperty||"llm_id",$scope.config[configProp]?(llmId=$scope.config[configProp],(foundLLM=$scope.llms.find(function(l){return l.llmId===llmId}))?($scope.selectedLLM=foundLLM,$scope.llmFilter=foundLLM.llmDisplayName):($scope.config[configProp]=null,$scope.selectedLLM=null,$scope.llmFilter="")):0<$scope.llms.length||($scope.llmFilter="")):($scope.llms=[],$scope.llmsByType={},$scope.selectedLLM=null,$scope.llmFilter="")},function(error){$scope.llms=[],$scope.llmsByType={},$scope.selectedLLM=null,$scope.llmFilter=""})};function llmDocumentClickHandler(event){$scope.isLLMDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){$scope.closeLLMDropdownAndRevertText()})}$scope.closeLLMDropdownAndRevertText=function(){$scope.isLLMDropdownOpen=!1,$scope.isLLMFocused=!1,angular.element(document).off("click",llmDocumentClickHandler),$scope.selectedLLM&&($scope.llmFilter=$scope.selectedLLM.llmDisplayName),$scope.filterActive=!1},$scope.openLLMDropdown=function(clearFilter){llmBlurTimeout&&$timeout.cancel(llmBlurTimeout),$scope.isLLMDropdownOpen?$scope.closeLLMDropdownAndRevertText():(clearFilter&&($scope.llmFilter=""),$scope.isLLMDropdownOpen=!0,$scope.filterActive=!1,$timeout(function(){angular.element(document).on("click",llmDocumentClickHandler)},0))},$scope.selectLLM=function(llm){llmBlurTimeout&&$timeout.cancel(llmBlurTimeout),$scope.selectedLLM=llm,$scope.config[$scope.configProperty||"llm_id"]=llm.llmId,$scope.llmFilter=llm.llmDisplayName,$scope.isLLMDropdownOpen=!1,$scope.isLLMFocused=!1,angular.element(document).off("click",llmDocumentClickHandler)},$scope.clearLLMSelection=function(){$scope.llmFilter="",$scope.selectedLLM=null,$scope.config[$scope.configProperty||"llm_id"]=null,$scope.openLLMDropdown(null,!0),$element[0].querySelector("input").focus()},$scope.handleLLMInputChange=function(){$scope.selectedLLM&&$scope.llmFilter!==$scope.selectedLLM.llmDisplayName&&($scope.selectedLLM=null,$scope.config[$scope.configProperty||"llm_id"]=null),$scope.filterActive=!0,!$scope.isLLMDropdownOpen&&$scope.llmFilter&&$scope.openLLMDropdown(null,!1)},$scope.handleLLMInputBlur=function(){llmBlurTimeout=$timeout(function(){$scope.isLLMDropdownOpen&&$scope.closeLLMDropdownAndRevertText()},200)},$scope.handleInputFocus=function(){$scope.isLLMDropdownOpen||$scope.openLLMDropdown(!1)},$scope.llmMatchesFilter=function(llm){var filter;return!$scope.filterActive||!$scope.llmFilter||(filter=$scope.llmFilter.toLowerCase(),llm.llmDisplayName.toLowerCase().includes(filter))||llm.llmType.toLowerCase().includes(filter)||llm.connection&&llm.connection.toLowerCase().includes(filter)||llm.model&&llm.model.toLowerCase().includes(filter)},$scope.typeHasMatchingLLMs=function(type){return!!$scope.llmsByType[type]&&$scope.llmsByType[type].some(l=>$scope.llmMatchesFilter(l))},$scope.hasMatchingLLMs=function(){return 0!==$scope.llms.length&&(!$scope.llmFilter||$scope.llms.some(l=>$scope.llmMatchesFilter(l)))},$scope.$on("$destroy",function(){angular.element(document).off("click",llmDocumentClickHandler)}),$scope.initLLMData()}]}}]);