llmApp.directive('columnSelector', ['$timeout','PLUGIN_PATHS', function ($timeout,PLUGIN_PATHS) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'column-selector-template.html',
        scope: {
            selectedColumn: '=',
            columnChoices: '<',
            formName: '=',
            labelText: '@',
            fieldRequired: '=',
            fieldName: '@',
            placeholder: '@?'
        },
        link: function (scope, element) {
            // Initialize scope properties
            scope.isDropdownOpen = false;
            scope.filterText = '';
            scope.isFocused = false;

            var blurTimeout = null;

            // Watch for selectedColumn changes
            scope.$watch('selectedColumn', function (newVal) {
                if (newVal) {
                    const selectedOption = scope.columnChoices.find(c => c.value === newVal);
                    scope.filterText = selectedOption ? selectedOption.label : '';
                } else {
                    scope.filterText = '';
                }
            });

            // Process columnChoices into grouped structure
            function processColumnChoices() {
                scope.columnsByTable = {};

                if (!scope.columnChoices) return;

                // Split each column's value into table and column name
                scope.columnChoices.forEach(col => {
                    const parts = col.value.split('.');
                    col.table = parts[0]; // First part is the table name
                    col.column = parts.slice(1).join('.') || col.value; // Remainder is the column name
                });

                // Group columns by table
                scope.columnChoices.forEach(col => {
                    if (!scope.columnsByTable[col.table]) {
                        scope.columnsByTable[col.table] = [];
                    }
                    scope.columnsByTable[col.table].push(col);
                });
            }

            processColumnChoices()


            scope.$watch('columnChoices', function (newChoices, oldChoices) {
                // Only proceed if the choices have actually changed.
                if (angular.equals(newChoices, oldChoices)) {
                    return;
                }

                // If new choices are available, process them.
                if (newChoices && newChoices.length > 0) {
                    processColumnChoices(); // Rebuild grouped columns

                    // Now, validate the existing selection against the NEW list.
                    if (scope.selectedColumn) {
                        const selectedOption = newChoices.find(c => c.value === scope.selectedColumn);
                        // If the previously selected column is NOT in the new list, clear it.
                        if (!selectedOption) {
                            scope.selectedColumn = null;
                            scope.filterText = '';
                        } else if (scope.filterText !== selectedOption.label) {
                            // This handles cases where the label might have changed for the same value.
                            scope.filterText = selectedOption.label;
                        }
                    }
                } else {
                    // If the new choices are empty or undefined (transient state),
                    // clear the internal representation but DO NOT nullify the `selectedColumn`.
                    // The model value will persist until a new list arrives for validation.
                    scope.columnsByTable = {};
                    scope.filterText = ''; // You may want to clear the visible text input
                }

            }, true); // Deep compare


            // Check if a table has matching columns (for filtering)
            scope.typeHasMatchingColumns = function (table) {
                // Check if columnsByTable exists and has the table
                if (!scope.columnsByTable || !scope.columnsByTable[table]) {
                    return false;
                }
                return scope.columnsByTable[table].some(col => scope.columnMatchesFilter(col));
            };
            // Update filter logic to check both table and column names
            scope.columnMatchesFilter = function (column) {
                if (!scope.filterText) return true;
                const filter = scope.filterText.toLowerCase();
                return (
                    column.column.toLowerCase().includes(filter) ||
                    column.table.toLowerCase().includes(filter)
                );
            };


            // Document click handler for closing dropdown
            var documentClickHandler = function (event) {
                if (scope.isDropdownOpen && !element[0].contains(event.target)) {
                    scope.$apply(function () {
                        scope.closeDropdownAndRevertText();
                    });
                }
            };

            // Close dropdown and revert text
            scope.closeDropdownAndRevertText = function () {
                scope.isDropdownOpen = false;
                angular.element(document).off('click', documentClickHandler);
                if (scope.selectedColumn) {
                    const selectedOption = scope.columnChoices.find(c => c.value === scope.selectedColumn);
                    scope.filterText = selectedOption ? selectedOption.label : '';
                } else {
                    scope.filterText = '';
                }
            };

            // Open dropdown
            scope.openDropdown = function ($event) {
                if ($event) $event.stopPropagation();
                if (blurTimeout) $timeout.cancel(blurTimeout);

                if (!scope.isDropdownOpen) {
                    scope.isDropdownOpen = true;
                    $timeout(function () {
                        angular.element(document).on('click', documentClickHandler);
                    }, 0);
                }
            };

            // Select a column
            scope.selectColumn = function (column) {
                if (blurTimeout) $timeout.cancel(blurTimeout);

                scope.selectedColumn = column.value;
                scope.filterText = column.label;
                scope.isDropdownOpen = false;
                angular.element(document).off('click', documentClickHandler);
            };

            // Clear selection
            scope.clearSelection = function () {
                scope.filterText = '';
                scope.selectedColumn = null;
                scope.openDropdown();
                element[0].querySelector('input').focus();
            };

            // Handle input change
            scope.handleInputChange = function () {
                if (scope.selectedColumn) {
                    const selectedOption = scope.columnChoices.find(c => c.value === scope.selectedColumn);
                    if (!selectedOption || scope.filterText !== selectedOption.label) {
                        scope.selectedColumn = null;
                    }
                }
                if (!scope.isDropdownOpen && scope.filterText) {
                    scope.openDropdown();
                }
            };

            // Handle input blur
            scope.handleInputBlur = function () {
                blurTimeout = $timeout(function () {
                    if (scope.isDropdownOpen) {
                        scope.closeDropdownAndRevertText();
                    }
                }, 200);
            };

            // Check if column matches filter
            scope.columnMatchesFilter = function (column) {
                if (!scope.filterText) return true;
                const filter = scope.filterText.toLowerCase();
                return column.label.toLowerCase().includes(filter);
            };

            // Check if there are matching columns
            scope.hasMatchingColumns = function () {
                if (scope.columnChoices.length === 0) return false;
                if (!scope.filterText) return true;
                return scope.columnChoices.some(col => scope.columnMatchesFilter(col));
            };

            // Cleanup on scope destroy
            scope.$on('$destroy', function () {
                if (blurTimeout) $timeout.cancel(blurTimeout);
                angular.element(document).off('click', documentClickHandler);
            });
        }
    };
}]);
