llmApp.directive('answersApiConfiguration',['PLUGIN_PATHS','SUPPORTED_CONNECTIONS' , function (PLUGIN_PATHS,SUPPORTED_CONNECTIONS) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'answers-api-configuration.html',
        scope: {
            config: '=', configForm: '='
        },
        controller: ['$scope', '$timeout', function ($scope, $timeout) {
            $scope.isExpanded = false;
            $scope.isAnswersHistoryDataset = false;
            $scope.isAnswersConversationDataset = false;
            $scope.config = $scope.config || {};
            $scope.supportedConnections = SUPPORTED_CONNECTIONS;
            // Initialize as object property
            $scope.state = {
                newMessagesHistoryDataset: false,
                newConversationHistoryDataset: false
            };

            $scope.toggleFlag = function (name) {
                if (name === "MessageHistory") {
                    $scope.state.newMessagesHistoryDataset = !$scope.state.newMessagesHistoryDataset;
                }
                else if (name === "ConversationHistory") {
                    $scope.state.newConversationHistoryDataset = !$scope.state.newConversationHistoryDataset;
                }
            };

            $scope.toggleExpand = function(propertyName) {
                $scope[propertyName] = !$scope[propertyName];
            };



        }]
    };
}]);
