from typing import Dict, List, Literal, TypedDict


class DatasetMetadata(TypedDict, total=False):
    columns: List[str]


# --------------- 'Dataiku Answers' configuration dataset names ---------------
# Logging dataset:
LOGGING_DATASET_CONF_ID = "logging_dataset"
# User profile dataset:
USER_PROFILE_DATASET_CONF_ID = "user_profile_dataset"
# General feedback dataset:
GENERAL_FEEDBACK_DATASET_CONF_ID = "general_feedback_dataset"

#New design 2.0
#Messages dataset
MESSAGE_DATASET_CONF_ID = "message_dataset"
#Conversation dataset
CONVERSATION_DATASET_CONF_ID = "conversation_dataset"
# --------------- Dataset metadatas ---------------
ANSWERS_DATASETS_METADATA: Dict[str, DatasetMetadata] = {
    LOGGING_DATASET_CONF_ID: {
        "columns": [
            "conversation_id",
            "conversation_name",
            "knowledge_bank_id",
            "knowledge_bank_name",
            "llm_name",
            "user",
            "message_id",
            "question",
            "filters",
            "file_path",
            "answer",
            "sources",
            "feedback_value",
            "feedback_choice",
            "feedback_message",
            "timestamp",
            "state",
            "llm_context",
            "generated_media",
        ],
    },
    USER_PROFILE_DATASET_CONF_ID: {
        "columns": ["user", "profile", "last_updated"],
    },
    GENERAL_FEEDBACK_DATASET_CONF_ID: {
        "columns": ["date", "user", "message", "knowledgebank", "llm"],
    },
    MESSAGE_DATASET_CONF_ID: {
        "columns": [
            "message_id",
            "user",
            "platform",
            "llm_name",
            "query",
            "answer",
            "filters",
            "sources",
            "created_at",
            "llm_context",
            "generated_media",
            "feedback",
            "conversation_id",
            "state",
            "history",
            # "updated_at" TODO should we have edited at and should we keep original text?
        ],
    },
    CONVERSATION_DATASET_CONF_ID: {
        "columns": [
            "conversation_id",
            "user",
            "platform",
            "created_at",
            "conversation_name", #can be a json to support edition of conversation name
            "updated_at", #TODO updated_at or last_message_at
            "state", #state if deleted, can also be edited - permenant delete
            "metadata", #metadata can be a json to store additional information
        ],
    },
}

ANSWERS_CONFIG_DATASETS = list(ANSWERS_DATASETS_METADATA.keys())
ConfigDatasetID = Literal["logging_dataset", "user_profile_dataset", "general_feedback_dataset", "message_dataset", "conversation_dataset"]