import json

import numpy as np
from common.backend.utils.dataiku_api import dataiku_api
from common.llm_assist.logging import logger
from flask import g, request


def return_ok(data={}) -> str:
    def convert_int64(obj):
        if isinstance(obj, np.int64):
            return int(obj)
        raise TypeError(f"An object of type '{type(obj)}' could not be dumped.")

    return json.dumps({"status": "ok", "data": data}, ensure_ascii=False, default=convert_int64)

def return_ok_message(message="")-> str:
    return json.dumps({"status": "ok", "message": message}, ensure_ascii=False)

def return_ko(message="") -> str:
    return json.dumps({"status": "ko", "message": message}, ensure_ascii=False)


def before_request():
    try:
        request_headers = dict(request.headers)
        auth_info_browser = dataiku_api.client.get_auth_info_from_browser_headers(
            request_headers
        )
        g.authIdentifier = auth_info_browser["authIdentifier"]
    except Exception as e:
        logger.warn("Authentication details extraction failed")
        g.authIdentifier = "unknown"


def extract_get_params(*params):
    return (request.args.get(param, None) for param in params)