from answers.solutions.vector_search.generic_vector_search import GenericVectorQuery
from answers.solutions.vector_search.models import VecOperator


class ChromaOperators(VecOperator):
    CONTAINS = "$contains"
    NOT_CONTAINS = "$not_contains"


class ChromaVectorQuery(GenericVectorQuery):
    def __init__(self):
        super().__init__(ChromaOperators)
        self.operator_methods.update({"contains": ChromaOperators.CONTAINS})
        self.operator_methods.update({"not_contains": ChromaOperators.NOT_CONTAINS})

    @property
    def supports_hybrid(self):
        return True

    @property
    def hybrid_key(self) -> str:
        return "where_document"
