import unittest
from unittest.mock import patch

from common.llm_assist.fallback import FALLBACK_LLM_KEY, get_fallback_id


class TestFallback(unittest.TestCase):
    @patch("common.llm_assist.fallback.dataiku_api")
    def test_get_fallback_id(self, mock_dataiku_api):
        mock_dataiku_api.webapp_config = {"advanced_hidden_settings": [{"from": FALLBACK_LLM_KEY, "to": "dummy_id"}]}
        fallback_id = get_fallback_id()
        assert fallback_id == "dummy_id"

    @patch("common.llm_assist.fallback.dataiku_api")
    def test_get_fallback_no_hidden(self, mock_dataiku_api):
        mock_dataiku_api.webapp_config = {"advanced_hidden_settings": []}
        fallback_id = get_fallback_id()
        assert fallback_id is None

    @patch("common.llm_assist.fallback.dataiku_api")
    def test_get_fallback_id_key_null(self, mock_dataiku_api):
        mock_dataiku_api.webapp_config = {"advanced_hidden_settings": [{"from": None, "to": "dummy_id"}]}
        fallback_id = get_fallback_id()
        assert fallback_id is None

    @patch("common.llm_assist.fallback.dataiku_api")
    def test_get_fallback_id_both_null(self, mock_dataiku_api):
        mock_dataiku_api.webapp_config = {"advanced_hidden_settings": [{"from": None, "to": None}]}
        fallback_id = get_fallback_id()
        assert fallback_id is None
