/* eslint-env node */
require('@rushstack/eslint-patch/modern-module-resolution');

module.exports = {
  root: true,
  ignorePatterns: ['../../js/**/*',
    '../custom-ui-settings/**/*'
  ],
  env: {
    node: true,
    browser: true,
    es6: true,
  },
  extends: [
    'plugin:vue/vue3-essential',
    'eslint:recommended',
    '@vue/eslint-config-typescript',
    '@vue/eslint-config-prettier/skip-formatting'
  ],
  rules: {
    "@typescript-eslint/ban-ts-comment": "warn",
    "@typescript-eslint/ban-types": "warn",
    "@typescript-eslint/member-ordering": "warn",
    "@typescript-eslint/naming-convention": "off",
    "@typescript-eslint/no-empty-function": "off",
    "@typescript-eslint/no-empty-interface": "warn",
    "@typescript-eslint/no-extra-semi": "warn",
    "@typescript-eslint/no-inferrable-types": "off",
    "@typescript-eslint/no-loss-of-precision": "warn",
    "@typescript-eslint/no-namespace": "off",
    "@typescript-eslint/no-non-null-asserted-optional-chain": "warn",
    "@typescript-eslint/no-non-null-assertion": "warn",
    "@typescript-eslint/no-this-alias": "warn",
    "@typescript-eslint/no-unsafe-argument": "off",
    "@typescript-eslint/no-unsafe-assignment": "off",
    "@typescript-eslint/no-unsafe-call": "off",
    "@typescript-eslint/no-unsafe-member-access": "off",
    "@typescript-eslint/no-unsafe-return": "off",
    "@typescript-eslint/no-var-requires": "warn",
    "arrow-parens": "off",
    "eol-last": "warn",
    "getter-return": "off",
    "import/order": "off",
    "no-dupe-class-members": "warn",
    "no-dupe-else-if": "warn",
    "no-empty": "warn",
    "no-extra-boolean-cast": "warn",
    "no-irregular-whitespace": "warn",
    "no-mixed-spaces-and-tabs": "warn",
    "no-prototype-builtins": "warn",
    "no-redeclare": "warn",
    "no-restricted-syntax": "warn",
    "no-trailing-spaces": "warn",
    "no-undef": "warn",
    "no-unexpected-multiline": "warn",
    "no-unsafe-optional-chaining": "warn",
    "no-useless-escape": "warn",
    "no-var": "warn",
    "prefer-const": "warn"
  },
  overrides: [
    {
      files: ['src/components/ui/**/*.vue'],
      rules: {
        'vue/multi-word-component-names': 'off'
      }
    }
  ]
};
