import { useSettings } from '@/components/composables/use-settings'

const { knowledgeBankSelection, filtersSelections, dbSelection } = useSettings()
import packageInfo from '../../package.json';
const version = packageInfo.version;

enum EventName {
  AskQuestion = "dataiku-answers-ask-question",
  GiveFeedback = "dataiku-answers-give-feedback",
  Open = "dataiku-answers-open",
  Error = "dataiku-answers-error",
  ClearHistory = "dataiku-answers-clear-history",
  NewConversation = "dataiku-answers-new-conversation",
  NewMediaConversation = "dataiku-answers-new-media-conversation",
  DeleteConversation = "dataiku-answers-delete-conversation",
  DeleteAllConversations = "dataiku-answers-delete-all-conversations",
}

export class WT1iser {
  public static llmId: string | undefined
  public static imageGenerationLlmId: string | undefined
  private static webappVersion = version

  public static open(): void {
    this.sendEvent(EventName.Open, {})
  }

  public static askQuestion(nQuestions: number) {
    this.sendEvent(EventName.AskQuestion, { nQuestions })
  }

  public static giveFeedback(
    nQuestions: number,
    feedbackType: string,
    feedbackHasComment: boolean
  ): void {
    this.sendEvent(EventName.GiveFeedback, { nQuestions, feedbackType, feedbackHasComment })
  }

  public static clearHistory(nQuestions: number): void {
    this.sendEvent(EventName.ClearHistory, { nQuestions })
  }

  public static newConversation() {
    this.sendEvent(EventName.NewConversation, {})
  }
  public static newMediaConversation() {
    this.sendEvent(EventName.NewConversation, {})
  }

  public static deleteConversation() {
    this.sendEvent(EventName.DeleteConversation, {})
  }

  public static deleteAllConversations() {
    this.sendEvent(EventName.DeleteAllConversations, {})
  }

  public static error(
    actionName: string,
    nQuestions: number,
    error: string
  ): void {
    this.sendEvent(EventName.Error, { actionName, nQuestions, error })
  }
  public static init(llmId: any, imageGenerationLlmId: string | undefined) {
    this.llmId = llmId ?? ''
    this.imageGenerationLlmId = imageGenerationLlmId ?? ''
    console.log('** answers version **', version)
    try {
      if (!(window.parent as any).WT1SVC && (window as any).dkuUsageReportingUtils) {
        console.debug('bootstrap standalone reporting mode')
        ;(window as any).dkuUsageReportingUtils.standaloneModeBootstrap()
      }
    } catch (error) {}
  }

  private static checkFilters(filtersActive: any): boolean {
    if (filtersActive && typeof filtersActive === 'object' && knowledgeBankSelection.value) {
      return Object.keys(filtersActive).length > 0
    } else {
      return false
    }
  }

  private static prepareEventParams(props: any) {
    return {
      ...props,
      kbActive: knowledgeBankSelection.value ? true : false,
      filtersActive: this.checkFilters(filtersSelections.value),
      llmId: this.llmId,
      webappVersion: this.webappVersion,
      dbActive: dbSelection.value ? true : false,
      imageGenerationLlmId: this.imageGenerationLlmId,
    }
  }

  private static sendEvent(event: EventName, props: any) {
    try {
      const params = this.prepareEventParams(props)
      if ((window.parent as any).WT1SVC) {
        (window.parent as any).WT1SVC.event(event, params)
      } else if ((window as any).dkuUsageReportingUtils) {
        (window as any).dkuUsageReportingUtils.standaloneModeTrackEvent(
          event,
          params
        )
      }
    } catch (error) {}
  }
}
