import { createApp } from 'vue';
import "@/assets/css/main.scss";
import "@/assets/css/index.css"
import 'prismjs/themes/prism-tomorrow.css'
import App from './App.vue';
import router from './router';
import i18n from './i18n';
import { registerDirectives } from './directives/register';
// load prism components
import 'prismjs/components/prism-javascript'; // JavaScript
import 'prismjs/components/prism-typescript'; // TypeScript
import 'prismjs/components/prism-css'; // CSS
import 'prismjs/components/prism-scss'; // SCSS
import 'prismjs/components/prism-json'; // JSON
import 'prismjs/components/prism-markup'; // XML, HTML, SVG, MathML, etc.
import 'prismjs/components/prism-bash'; // Bash/Shell
import 'prismjs/components/prism-python'; // Python
import 'prismjs/components/prism-java'; // Java
import 'prismjs/components/prism-csharp'; // C#
import 'prismjs/components/prism-c'; // C
import 'prismjs/components/prism-cpp'; // C++
import './common/md5';

const app = createApp(App)

app.use(router)
registerDirectives(app);
app.use(i18n);

app.mount('#app')
