import { ref } from 'vue'

const isLoading = ref(false)
const message = ref('')

export function useLoading() {
  const showLoading = (msg = 'Loading...') => {
    message.value = msg
    isLoading.value = true
  }

  const hideLoading = () => {
    isLoading.value = false
    message.value = ''
  }

  return {
    isLoading,
    message,
    showLoading,
    hideLoading,
  }
}
