/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.gdpr;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.cuspol.CustomPolicyHooks;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.input.ExportDataset;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.ExportShaker;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GDPRHooks
extends CustomPolicyHooks {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private RegularPluginsRegistryService regularPluginsRegistryService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.plugins.gdpr.hooks");

    public void onPreDatasetCreation(AuthCtx user, SerializedDataset serializedDataset, DatasetSaveService.DatasetCreationContext context) throws Exception {
        boolean hasPersonalData;
        InfoMessage.MessageCode mc = new InfoMessage.MessageCode(){

            public String getCode() {
                return "ERR_GDPR_DATASET_CREATION";
            }

            public String getCodeTitle() {
                return "Cannot create dataset";
            }

            public InfoMessage.FixabilityCategory getFixability() {
                return InfoMessage.FixabilityCategory.ADMIN_SETTINGS_PLUGINS;
            }
        };
        boolean bl = hasPersonalData = !serializedDataset.customFields.has("gdpr_contains_personal_data") || !"NO".equals(serializedDataset.customFields.get("gdpr_contains_personal_data").getAsString());
        if (hasPersonalData && context.type == DatasetSaveService.DatasetCreationContext.DatasetCreationType.COPY_FROM_ANOTHER_PROJECT) {
            boolean forbidSharing;
            SerializedProject originPrj = this.projectsService.getMandatoryUnsafe(context.originProjectKey);
            boolean bl2 = forbidSharing = originPrj.customFields != null && originPrj.customFields.has("gdpr_forbid_dataset_sharing") && originPrj.customFields.get("gdpr_forbid_dataset_sharing").getAsBoolean();
            if (forbidSharing) {
                throw new CodedException(mc, "GDPR policies on this project forbid sharing datasets that contain personal data (dataset: " + context.originDatasetName + ")");
            }
        }
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(serializedDataset.projectKey);
        HashSet<String> forbiddenConnections = new HashSet<String>();
        if (sp.customFields.has("gdpr_forbidden_connections")) {
            for (JsonElement conn : sp.customFields.get("gdpr_forbidden_connections").getAsJsonArray()) {
                if (!StringUtils.isNotBlank((CharSequence)conn.getAsString())) continue;
                forbiddenConnections.add(conn.getAsString());
            }
        }
        if (serializedDataset.getParams().getConnection() != null) {
            if (forbiddenConnections.contains(serializedDataset.getParams().getConnection())) {
                throw new CodedException(mc, "GDPR policies on this project forbid creating datasets on connection " + serializedDataset.getParams().getConnection() + " (dataset: " + serializedDataset.name + ")");
            }
        } else if ("UploadedFiles".equals(serializedDataset.getSubtype())) {
            if (sp.customFields.has("gdpr_forbid_uploaded_datasets") && sp.customFields.get("gdpr_forbid_uploaded_datasets").getAsBoolean()) {
                throw new CodedException(mc, "GDPR policies on this project forbid creating uploaded datasets (dataset: " + serializedDataset.name + ")");
            }
            if (serializedDataset.getParams() instanceof BuiltinFSDatasets.UploadedFilesConfig) {
                BuiltinFSDatasets.UploadedFilesConfig upCfg = (BuiltinFSDatasets.UploadedFilesConfig)serializedDataset.getParams();
                if (forbiddenConnections.contains(upCfg.uploadConnection)) {
                    throw new CodedException(mc, "GDPR policies on this project forbid creating datasets on connection " + upCfg.uploadConnection + " (dataset: " + serializedDataset.name + ")");
                }
            }
        }
    }

    public void onPreMLModelCreation(AuthCtx user, SerializedDataset sd, AnalysisCoreParams analysis, MLTask mlTask) throws Exception {
        boolean forbidCreation;
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(analysis.projectKey);
        InfoMessage.MessageCode mc = new InfoMessage.MessageCode(){

            public String getCode() {
                return "ERR_GDPR_MODEL_CREATION";
            }

            public String getCodeTitle() {
                return "Cannot create model";
            }

            public InfoMessage.FixabilityCategory getFixability() {
                return InfoMessage.FixabilityCategory.ADMIN_SETTINGS_PLUGINS;
            }
        };
        boolean hasPersonalData = !sd.customFields.has("gdpr_contains_personal_data") || !"NO".equals(sd.customFields.get("gdpr_contains_personal_data").getAsString());
        boolean bl = forbidCreation = sp.customFields.has("gdpr_forbid_model_creation") && sp.customFields.get("gdpr_forbid_model_creation").getAsBoolean();
        if (hasPersonalData && forbidCreation) {
            throw new CodedException(mc, "GDPR policies on this project forbid model creation on datasets that contain personal data (dataset: " + sd.name + ")");
        }
    }

    public void onPreSharedItemsSave(AuthCtx user, SerializedProject before, SerializedProject after) throws Exception {
        boolean sameValue;
        boolean forbidSharing;
        boolean bl = forbidSharing = before != null && before.customFields != null && before.customFields.has("gdpr_forbid_dataset_sharing") && before.customFields.get("gdpr_forbid_dataset_sharing").getAsBoolean();
        if (!forbidSharing) {
            return;
        }
        boolean beforeNull = before == null || before.exposedObjects == null;
        boolean bothNulls = beforeNull && after.exposedObjects == null;
        boolean bl2 = sameValue = bothNulls || !beforeNull && before.exposedObjects.equals((Object)after.exposedObjects);
        if (sameValue || after.exposedObjects == null || after.exposedObjects.objects == null || after.exposedObjects.objects.isEmpty()) {
            return;
        }
        InfoMessage.MessageCode mc = new InfoMessage.MessageCode(){

            public String getCode() {
                return "ERR_GDPR_SHARED_ITEM_SAVE";
            }

            public String getCodeTitle() {
                return "Cannot save shared items";
            }

            public InfoMessage.FixabilityCategory getFixability() {
                return InfoMessage.FixabilityCategory.ADMIN_SETTINGS_PLUGINS;
            }
        };
        for (ExposedObject eo : after.exposedObjects.objects) {
            if (eo.type != ITaggingService.TaggableType.DATASET) continue;
            boolean eoHasChanged = true;
            if (!beforeNull && before.exposedObjects.objects != null && !before.exposedObjects.objects.isEmpty()) {
                boolean beoFound = false;
                for (ExposedObject beo : before.exposedObjects.objects) {
                    if (!eo.localName.equals(beo.localName)) continue;
                    eoHasChanged = !beoFound ? !beo.equals((Object)eo) : eoHasChanged || !beo.equals((Object)eo);
                    beoFound = true;
                    if (!eoHasChanged) continue;
                    break;
                }
            }
            if (!eoHasChanged) continue;
            SerializedDataset sd = this.datasetAccessService.getMandatoryUnsafe(AnyLoc.resolveSmart((String)before.projectKey, (String)eo.localName)).getModel();
            boolean hasPersonalData = !sd.customFields.has("gdpr_contains_personal_data") || !"NO".equals(sd.customFields.get("gdpr_contains_personal_data").getAsString());
            if (!hasPersonalData) continue;
            throw new CodedException(mc, "GDPR policies on this project forbid sharing datasets that contain personal data (dataset: " + sd.name + ")");
        }
    }

    public void onPreDataExport(AuthCtx user, ExportInput input, ExportParams params, ExportStatus.ExportMethod exportMethod) throws Exception {
        boolean forbidExport;
        if (!(input instanceof ExportDataset) && !(input instanceof ExportShaker)) {
            return;
        }
        FuturePayload.FuturePayloadTarget fpt = input.getSource();
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(fpt.projectKey);
        SerializedDataset sd = this.datasetAccessService.getMandatoryUnsafe(AnyLoc.resolveSmart((String)fpt.projectKey, (String)fpt.objectId)).getModel();
        InfoMessage.MessageCode mc = new InfoMessage.MessageCode(){

            public String getCode() {
                return "ERR_GDPR_EXPORT_DATASET";
            }

            public String getCodeTitle() {
                return "Cannot export dataset";
            }

            public InfoMessage.FixabilityCategory getFixability() {
                return InfoMessage.FixabilityCategory.ADMIN_SETTINGS_PLUGINS;
            }
        };
        boolean hasPersonalData = !sd.customFields.has("gdpr_contains_personal_data") || !"NO".equals(sd.customFields.get("gdpr_contains_personal_data").getAsString());
        boolean bl = forbidExport = sp.customFields.has("gdpr_forbid_dataset_export") && sp.customFields.get("gdpr_forbid_dataset_export").getAsBoolean();
        if (hasPersonalData && forbidExport) {
            throw new CodedException(mc, "GDPR policies on this project forbid exporting datasets that contain personal data (dataset: " + sd.name + ")");
        }
    }

    public void onPreProjectExport(AuthCtx user, String projectKey, ProjectExportOptions exportOptions) throws Exception {
        boolean forbidExport;
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        InfoMessage.MessageCode mc = new InfoMessage.MessageCode(){

            public String getCode() {
                return "ERR_GDPR_EXPORT_PROJECT";
            }

            public String getCodeTitle() {
                return "Cannot export project";
            }

            public InfoMessage.FixabilityCategory getFixability() {
                return InfoMessage.FixabilityCategory.ADMIN_SETTINGS_PLUGINS;
            }
        };
        boolean exportHasData = exportOptions.exportUploads || exportOptions.exportManagedFS || exportOptions.exportAnalysisModels || exportOptions.exportSavedModels || exportOptions.exportManagedFolders || exportOptions.exportAllInputDatasets || exportOptions.exportAllDatasets || exportOptions.exportAllInputManagedFolders || exportOptions.exportInsightsData || exportOptions.includedDatasetsData != null && !exportOptions.includedDatasetsData.isEmpty() || exportOptions.includedManagedFolders != null && !exportOptions.includedManagedFolders.isEmpty() || exportOptions.includedSavedModels != null && !exportOptions.includedSavedModels.isEmpty();
        boolean bl = forbidExport = sp.customFields.has("gdpr_forbid_dataset_export") && sp.customFields.get("gdpr_forbid_dataset_export").getAsBoolean();
        if (exportHasData && forbidExport) {
            throw new CodedException(mc, "GDPR policies on this project forbid exporting the project if it includes data");
        }
    }

    public void onPreObjectSave(AuthCtx user, TaggableObjectsService.TaggableObject before, TaggableObjectsService.TaggableObject after) throws Exception {
        JsonObject pluginSettings = this.regularPluginsRegistryService.getSettings((String)"gdpr").config;
        if (after instanceof SerializedProject) {
            InfoMessage.MessageCode mc = new InfoMessage.MessageCode(){

                public String getCode() {
                    return "ERR_GDPR_PROJECT_SAVE";
                }

                public String getCodeTitle() {
                    return "Cannot save project";
                }

                public InfoMessage.FixabilityCategory getFixability() {
                    return InfoMessage.FixabilityCategory.ADMIN_SETTINGS_PLUGINS;
                }
            };
            ArrayList<CustomFieldNameWithDefaultValue> adminCfs = new ArrayList<CustomFieldNameWithDefaultValue>();
            adminCfs.add(new CustomFieldNameWithDefaultValue("gdpr_forbid_dataset_sharing", (JsonElement)new JsonPrimitive(Boolean.valueOf(false))));
            adminCfs.add(new CustomFieldNameWithDefaultValue("gdpr_forbid_dataset_export", (JsonElement)new JsonPrimitive(Boolean.valueOf(false))));
            adminCfs.add(new CustomFieldNameWithDefaultValue("gdpr_forbid_model_creation", (JsonElement)new JsonPrimitive(Boolean.valueOf(false))));
            adminCfs.add(new CustomFieldNameWithDefaultValue("gdpr_forbid_uploaded_datasets", (JsonElement)new JsonPrimitive(Boolean.valueOf(false))));
            adminCfs.add(new CustomFieldNameWithDefaultValue("gdpr_forbidden_connections", null));
            CustomFieldsChangeRule adminRule = new CustomFieldsChangeRule(pluginSettings, "gdpr_admin_groups", adminCfs);
            this.handleCustomFieldsChange(user, before == null ? null : before.customFields, after == null ? null : after.customFields, adminRule, mc);
        } else if (after instanceof SerializedDataset) {
            boolean connHasChanged;
            InfoMessage.MessageCode mc = new InfoMessage.MessageCode(){

                public String getCode() {
                    return "ERR_GDPR_DATASET_SAVE";
                }

                public String getCodeTitle() {
                    return "Cannot save dataset";
                }

                public InfoMessage.FixabilityCategory getFixability() {
                    return InfoMessage.FixabilityCategory.ADMIN_SETTINGS_PLUGINS;
                }
            };
            ArrayList<CustomFieldNameWithDefaultValue> docCfs = new ArrayList<CustomFieldNameWithDefaultValue>();
            docCfs.add(new CustomFieldNameWithDefaultValue("gdpr_contains_personal_data", (JsonElement)new JsonPrimitive("UNSURE")));
            docCfs.add(new CustomFieldNameWithDefaultValue("gdpr_purposes", null));
            docCfs.add(new CustomFieldNameWithDefaultValue("gdpr_retention_policy", null));
            docCfs.add(new CustomFieldNameWithDefaultValue("gdpr_legal_consent", null));
            CustomFieldsChangeRule docRule = new CustomFieldsChangeRule(pluginSettings, "gdpr_doc_groups", docCfs);
            this.handleCustomFieldsChange(user, before == null ? null : before.customFields, after == null ? null : after.customFields, docRule, mc);
            String afterConnection = ((SerializedDataset)after).getParams().getConnection();
            boolean bl = connHasChanged = before == null || afterConnection != null && !StringUtils.equals((CharSequence)((SerializedDataset)before).getParams().getConnection(), (CharSequence)afterConnection);
            if (connHasChanged) {
                SerializedProject sp = this.projectsService.getMandatoryUnsafe(((SerializedDataset)after).projectKey);
                HashSet<String> forbiddenConnections = new HashSet<String>();
                if (sp.customFields.has("gdpr_forbidden_connections")) {
                    for (JsonElement conn : sp.customFields.get("gdpr_forbidden_connections").getAsJsonArray()) {
                        if (!StringUtils.isNotBlank((CharSequence)conn.getAsString())) continue;
                        forbiddenConnections.add(conn.getAsString());
                    }
                }
                if (forbiddenConnections.contains(afterConnection)) {
                    throw new CodedException(mc, "GDPR policies on this project forbid using connection " + afterConnection + " (dataset: " + (before != null ? ((SerializedDataset)before).name : ((SerializedDataset)after).name) + ")");
                }
            }
        } else if (after instanceof SerializedRecipe) {
            this.handleRecipeInputsOutputs(user, (SerializedRecipe)before, (SerializedRecipe)after);
        }
    }

    private void handleCustomFieldsChange(AuthCtx user, JsonObject before, JsonObject after, CustomFieldsChangeRule rule, InfoMessage.MessageCode mc) throws Exception {
        String groups;
        boolean hasGroupsKey = rule.pluginSettings != null && rule.pluginSettings.has(rule.key);
        String string = groups = hasGroupsKey ? rule.pluginSettings.get(rule.key).getAsString() : null;
        if (user.isGroupsAware() && groups != null) {
            for (String group : groups.split(",")) {
                if (!user.isInGroup(group)) continue;
                return;
            }
        }
        for (CustomFieldNameWithDefaultValue cfWDv : rule.customFieldNames) {
            boolean afterOnlyNull;
            String cfName = cfWDv.name;
            boolean beforeMissingCf = before == null || !before.has(cfName);
            boolean afterMissingCf = after == null || !after.has(cfName);
            JsonElement beforeValue = beforeMissingCf ? cfWDv.defaultValue : before.get(cfName);
            JsonElement afterValue = afterMissingCf ? cfWDv.defaultValue : after.get(cfName);
            boolean bothNulls = beforeValue == null && afterValue == null;
            boolean beforeOnlyNull = beforeValue == null && afterValue != null;
            boolean bl = afterOnlyNull = beforeValue != null && afterValue == null;
            if (bothNulls || !beforeOnlyNull && !afterOnlyNull && JSON.jsonEquals((Object)beforeValue, (Object)afterValue)) continue;
            throw new CodedException(mc, "GDPR policies forbid you to edit metadata field " + cfName + " since you do not belong to one of the following groups: " + (groups == null ? "" : groups));
        }
    }

    private void handleRecipeInputsOutputs(AuthCtx user, SerializedRecipe recipeBeforeChanges, SerializedRecipe recipeToSave) throws Exception {
        SerializedDataset sd;
        Dataset ds;
        boolean hasPersoDataOrUnsureInput = false;
        for (SerializedRecipe.RecipeInput input : recipeToSave.getFlatInputs()) {
            ds = this.datasetAccessService.getOrNullUnsafe(input.getLoc(recipeToSave.projectKey));
            if (ds == null) continue;
            sd = ds.getModel();
            if (sd.customFields.has("gdpr_contains_personal_data") && "NO".equals(sd.customFields.get("gdpr_contains_personal_data").getAsString())) continue;
            hasPersoDataOrUnsureInput = true;
            break;
        }
        if (hasPersoDataOrUnsureInput) {
            for (SerializedRecipe.RecipeOutput output : recipeToSave.getFlatOutputs()) {
                ds = this.datasetAccessService.getOrNullUnsafe(output.getLoc(recipeToSave.projectKey));
                if (ds == null) continue;
                sd = ds.getModel();
                if (!sd.customFields.has("gdpr_contains_personal_data") || !"NO".equals(sd.customFields.get("gdpr_contains_personal_data").getAsString())) continue;
                sd.customFields.addProperty("gdpr_contains_personal_data", "UNSURE");
                this.datasetSaveService.save(ds.getLoc(), sd, user);
            }
        }
    }

    private static class CustomFieldsChangeRule {
        private final JsonObject pluginSettings;
        private final String key;
        private final List<CustomFieldNameWithDefaultValue> customFieldNames;

        private CustomFieldsChangeRule(JsonObject pluginSettings, String key, List<CustomFieldNameWithDefaultValue> customFieldNames) {
            this.pluginSettings = pluginSettings;
            this.key = key;
            this.customFieldNames = customFieldNames;
        }
    }

    private static class CustomFieldNameWithDefaultValue {
        private final String name;
        private final JsonElement defaultValue;

        private CustomFieldNameWithDefaultValue(String name, JsonElement defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }
    }
}

