from dku_plugin_config_loading import DkuConfigLoadingIsochrone
from graphhopper_geo_router import GraphhopperGeoRouter
import dataiku
import time
import logging

logging.basicConfig(level="INFO")
logger = logging.getLogger(__name__)

# Read plugin recipe settings
dku_license_id = dataiku.api_client().get_instance_info().raw["licenseId"]
dku_config = DkuConfigLoadingIsochrone()
settings = dku_config.load_settings()

# Initialize worker
geo_router = GraphhopperGeoRouter(api_endpoint_url=settings.api_endpoint_url, dku_license_id=dku_license_id)

# Process
start = time.perf_counter()
geo_router.run_get_isochrones(
    input_dataset=settings.input_dataset,
    output_dataset=settings.output_dataset,
    coords_col=settings.coords_column,
    time_threshold=settings.time_threshold,
    transport_mode=settings.transport_mode,
    transport_mode_col=settings.transport_mode_column,
    batch_size=settings.batch_size,
    parallel_workers=settings.isochrones_parallel_workers,
    use_cache=settings.use_cache,
    cache_size=settings.cache_size
)
end = time.perf_counter()
logger.info("total time spent processing data : " + str(end-start) + "seconds")