from dku_plugin_config_loading import DkuConfigLoadingRouting
from dkulib.io_utils.dku_utils import set_column_descriptions
import logging
import dataiku
from graphhopper_geo_router import GraphhopperGeoRouter
import time

logging.basicConfig(level="INFO")
logger = logging.getLogger(__name__)

# Read plugin recipe settings
dku_license_id = dataiku.api_client().get_instance_info().raw["licenseId"]
dku_config = DkuConfigLoadingRouting()
settings = dku_config.load_settings()

# Initialize worker
geo_router = GraphhopperGeoRouter(api_endpoint_url=settings.api_endpoint_url, dku_license_id=dku_license_id)

# Process
start = time.perf_counter()
geo_router.run_get_routes(
    input_dataset=settings.input_dataset,
    output_dataset=settings.output_dataset,
    from_col=settings.from_column,
    to_col=settings.to_column,
    transport_mode=settings.transport_mode,
    distance_unit=settings.distance_unit,
    get_itinerary=settings.get_itinerary,
    transport_mode_col=settings.transport_mode_column,
    parallel_workers=settings.routes_parallel_workers,
    batch_size=settings.batch_size,
    use_cache=settings.use_cache,
    cache_size=settings.cache_size
)
end = time.perf_counter()
logger.info("total time spent processing data : " + str(end-start) + "seconds")

# Output dataset manipulation
set_column_descriptions(
    output_dataset=settings.output_dataset,
    column_descriptions={"time": "Time in minutes", "distance": f"Distance in {settings.distance_unit.value}"},
)
