from enum import Enum
from collections import OrderedDict

class RECIPE(Enum):
    ISOCHRONE = "isochrone"
    ROUTE = "route"


class DISTANCE_UNIT(Enum):
    METERS = "meters"
    KILOMETERS = "kilometers"
    MILES = "miles"


class TRANSPORT_MODE(Enum):
    CAR = "car"
    BIKE = "bicycle"
    PEDESTRIAN = "pedestrian"
    PARSE_COL = "parse_col"


class CONVERSION(Enum):
    MILE_IN_METERS = 1609.344
    KILOMETER_IN_METERS = 1000
    MINUTE_IN_MILLISECONDS = 60000


REGIONS = {
    "auto": "https://geo-router.api-services.dataiku.io",
    "europe": "https://geo-router.emea1.api-services.dataiku.io",
    "america": "https://geo-router.amer1.api-services.dataiku.io"
}


KNOWN_ERROR_MESSAGES = {
    "Cannot find point": "No nearby route found",
    "Point not found": "No nearby route found"
}

OUTPUT_COLUMN_NAME_DESCRIPTIONS = OrderedDict(
    [
        ("response", "Raw response in JSON format"),
        ("error_message", "Error message"),
        ("error_type", "Error type or code"),
        ("error_raw", "Raw error"),
    ]
)

CACHE_DIR = '.cache/dss/plugins/georouting/'
CACHE_NUM_SHARDS = 10
CACHE_TIMEOUT = 0.5
