from dataiku.runnables import Runnable, ResultTable
import os
import pwd
import shutil
from dkuconstants import CACHE_DIR

class CacheClearner(Runnable):
    """The base interface for a Python runnable"""

    def __init__(self, project_key, config, plugin_config):
        """
        :param project_key: the project in which the runnable executes
        :param config: the dict of the configuration of the object
        :param plugin_config: contains the plugin settings
        """
        self.project_key = project_key
        self.config = config
        self.plugin_config = plugin_config

    def run(self, progress_callback):
        """
        The progress_callback is a function expecting 1 value: current progress
        """
        cache_dir = os.path.join(pwd.getpwuid(os.getuid()).pw_dir, CACHE_DIR)
        if os.path.isdir(cache_dir):
            shutil.rmtree(cache_dir)
            return "Cache cleared successfully"
        else:
            return "Cache is already empty. Nothing to delete."
