import dku_graphrag.utils.config_instance as config_instance
import graphrag.query.llm.get_client
from dku_graphrag.query.query_dataiku_chat_llm import QueryDataikuChatLLM
from dku_graphrag.query.query_dataiku_embedding_llm import QueryDataikuEmbeddingLLM


def monkeypatched_get_llm(config):
    return QueryDataikuChatLLM(config_instance.config_value.get("chat_completion_llm_id"))


def monkeypatched_get_text_embedder(config):
    return QueryDataikuEmbeddingLLM(config_instance.config_value.get("embedding_llm_id"))


graphrag.query.llm.get_client.get_llm = monkeypatched_get_llm
graphrag.query.llm.get_client.get_text_embedder = monkeypatched_get_text_embedder
