/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.formats.kml;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.plugin.CustomFormat;
import com.dataiku.dip.plugin.CustomFormatInput;
import com.dataiku.dip.plugin.CustomFormatOutput;
import com.dataiku.dip.plugin.CustomFormatSchemaDetector;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.util.XMLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.utils.KMLParser;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KMLFormat
implements CustomFormat {
    private static DKULogger logger = DKULogger.getLogger((String)"dku");

    public CustomFormatInput getReader(JsonObject config, JsonObject pluginConfig) {
        return new KMLFormatInput();
    }

    public CustomFormatOutput getWriter(JsonObject config, JsonObject pluginConfig) {
        return new KMLFormatOutput();
    }

    public CustomFormatSchemaDetector getDetector(JsonObject config, JsonObject pluginConfig) {
        return new KMLFormatDetector();
    }

    public static class KMLFormatDetector
    implements CustomFormatSchemaDetector {
        public Schema readSchema(InputStreamWithContextInfo in) throws Exception {
            return null;
        }

        public void close() throws IOException {
        }
    }

    public static class KMLFormatOutput
    implements CustomFormatOutput {
        public void close() throws IOException {
        }

        public void header(ColumnFactory cf, OutputStream os) throws IOException, Exception {
        }

        public void format(Row row, ColumnFactory cf, OutputStream os) throws IOException, Exception {
        }

        public void footer(ColumnFactory cf, OutputStream os) throws IOException, Exception {
        }

        public void cancel(OutputStream os) throws IOException, Exception {
        }

        public void setOutputSchema(Schema schema) {
        }

        public void setWarningsContext(WarningsContext warningsContext) {
        }
    }

    public class KMLFormatInput
    implements CustomFormatInput {
        public void setSchema(Schema schema, boolean allowExtraColumns) {
        }

        public void setWarningsContext(WarningsContext warnContext) {
        }

        public void run(InputStreamWithContextInfo in, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
            InputStream is;
            if (in.getFilename() != null && in.getFilename().endsWith(".kmz")) {
                ZipEntry entry;
                logger.info((Object)"Parsing KMZ");
                logger.info((Object)("Get following filename: " + in.getFilename()));
                InputStream inputStream = in.getInputStream();
                ZipInputStream zis = new ZipInputStream(inputStream);
                ByteArrayOutputStream os = null;
                while ((entry = zis.getNextEntry()) != null) {
                    int count;
                    if (!entry.getName().equals("doc.kml")) continue;
                    os = new ByteArrayOutputStream();
                    byte[] data = new byte[1024];
                    while ((count = zis.read(data, 0, 1024)) != -1) {
                        os.write(data, 0, count);
                    }
                }
                is = new ByteArrayInputStream(os.toByteArray());
            } else {
                logger.info((Object)"Parsing KML");
                logger.infoV("Get following filename: {}", new Object[]{in.getFilename()});
                is = in.getInputStream();
            }
            Document domDoc = XMLUtils.parse((InputStream)is);
            KMLParser kmlParser = new KMLParser();
            Element kmlElt = domDoc.getDocumentElement();
            Element documentElt = kmlParser.getFirstNodeByTagName(kmlElt, "Document");
            kmlParser.parseContainer(documentElt, out, cf, rf);
        }

        public void close() throws IOException {
        }
    }
}

