/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.utils;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.utils.DKULogger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KMLParser {
    private static DKULogger logger = DKULogger.getLogger((String)"dku");

    public Element getFirstNodeByTagName(Element parent, String name) {
        NodeList nl = parent.getElementsByTagName(name);
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    private void putAttrValueIfExists(ColumnFactory cf, Row r, String columnName, Element e, String attrName) {
        String attrValue = e.getAttribute(attrName);
        if (!StringUtils.isBlank((String)attrValue)) {
            r.put(cf.column(columnName), attrValue);
        }
    }

    private void putContentIfExistsInChild(ColumnFactory cf, Row r, String columnName, Element e, String childNodeName) {
        String txt;
        Element childNode = this.getFirstNodeByTagName(e, childNodeName);
        if (childNode != null && (txt = childNode.getTextContent()) != null) {
            r.put(cf.column(columnName), txt);
        }
    }

    private void parsePlacemark(Node node, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
        if (node instanceof Element) {
            boolean foundParsableGeoObject;
            Element e = (Element)node;
            Row r = rf.row();
            this.putContentIfExistsInChild(cf, r, "name", e, "name");
            boolean foundPoint = this.extractAndSetPoint(cf, e, r);
            boolean foundLineString = this.extractAndSetLineString(cf, e, r);
            boolean foundPolygon = this.extractAndSetPolygon(cf, e, r);
            boolean bl = foundParsableGeoObject = foundLineString || foundPoint || foundPolygon;
            if (foundParsableGeoObject) {
                this.putAttrValueIfExists(cf, r, "id", e, "id");
                this.extractAndSetExtendedData(cf, e, r);
                this.putContentIfExistsInChild(cf, r, "description", e, "description");
                this.putContentIfExistsInChild(cf, r, "snippet", e, "Snippet");
                this.putContentIfExistsInChild(cf, r, "address", e, "address");
                this.putContentIfExistsInChild(cf, r, "phoneNumber", e, "phoneNumber");
                out.emitRow(r);
            } else {
                logger.infoV("Warning: A placemark has been skipped due to unsupported geospatial format.", new Object[0]);
            }
        }
    }

    private void extractAndSetExtendedData(ColumnFactory cf, Element e, Row r) {
        NodeList nl;
        Element extendedDataElt = this.getFirstNodeByTagName(e, "ExtendedData");
        if (extendedDataElt != null && (nl = extendedDataElt.getElementsByTagName("Data")) != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                String dataValue;
                Element valueElt;
                Element dataElt;
                String dataName;
                if (!(nl.item(i) instanceof Element) || StringUtils.isBlank((String)(dataName = (dataElt = (Element)nl.item(i)).getAttribute("name"))) || (valueElt = this.getFirstNodeByTagName(dataElt, "value")) == null || StringUtils.isBlank((String)(dataValue = valueElt.getTextContent()))) continue;
                r.put(cf.column(dataName), dataValue.trim());
            }
        }
    }

    private boolean extractAndSetPoint(ColumnFactory cf, Element e, Row r) {
        boolean foundPoint = false;
        Element pointNode = this.getFirstNodeByTagName(e, "Point");
        if (pointNode != null) {
            String[] chunks;
            String coordsTxt;
            Element coordsElt = this.getFirstNodeByTagName(pointNode, "coordinates");
            if (coordsElt != null && (coordsTxt = coordsElt.getTextContent()) != null && (chunks = coordsTxt.split(",")).length >= 2) {
                GeoPoint.Coords coords = new GeoPoint.Coords(Double.parseDouble(chunks[1]), Double.parseDouble(chunks[0]));
                r.put(cf.column("geom"), coords.toWKT());
            }
            foundPoint = true;
        }
        return foundPoint;
    }

    private boolean extractAndSetLineString(ColumnFactory cf, Element e, Row r) {
        boolean foundLineString = false;
        Element linestringNode = this.getFirstNodeByTagName(e, "LineString");
        if (linestringNode != null) {
            String[] points;
            String coordsTxt;
            Element coordsElt = this.getFirstNodeByTagName(linestringNode, "coordinates");
            if (coordsElt != null && (coordsTxt = coordsElt.getTextContent()) != null && (points = StringUtils.splitByWholeSeparator((String)coordsTxt, (String)" ")) != null) {
                ArrayList<String> pointsStr = new ArrayList<String>();
                for (String point : points) {
                    String[] chunks;
                    if (StringUtils.isBlank((String)point) || (chunks = point.split(",")).length < 2) continue;
                    this.formatGeoCoord(pointsStr, chunks);
                }
                if (pointsStr.size() >= 2) {
                    r.put(cf.column("geom"), "LINESTRING(" + StringUtils.join(pointsStr, (String)",") + ")");
                }
            }
            foundLineString = true;
        }
        return foundLineString;
    }

    private void formatGeoCoord(List<String> pointsStr, String[] chunks) {
        double lat = Double.parseDouble(chunks[1]);
        double lng = Double.parseDouble(chunks[0]);
        DecimalFormat fmt = GeoPoint.getLatitudeLongitudeFormat();
        pointsStr.add(fmt.format(lng) + " " + fmt.format(lat));
    }

    private boolean extractAndSetPolygon(ColumnFactory cf, Element e, Row r) {
        boolean foundPolygon = false;
        Element linestringNode = this.getFirstNodeByTagName(e, "Polygon");
        if (linestringNode != null) {
            String[] points;
            String coordsTxt;
            Element coordsElt = this.getFirstNodeByTagName(linestringNode, "coordinates");
            if (coordsElt != null && (coordsTxt = coordsElt.getTextContent()) != null && (points = StringUtils.splitByWholeSeparator((String)coordsTxt, (String)" ")) != null) {
                ArrayList<String> pointsStr = new ArrayList<String>();
                for (String point : points) {
                    String[] chunks;
                    if (StringUtils.isBlank((String)point) || (chunks = point.split(",")).length < 2) continue;
                    this.formatGeoCoord(pointsStr, chunks);
                }
                if (pointsStr.size() >= 2) {
                    r.put(cf.column("geom"), "POLYGON((" + StringUtils.join(pointsStr, (String)",") + "))");
                }
            }
            foundPolygon = true;
        }
        return foundPolygon;
    }

    public void parseContainer(Node containerNode, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
        for (int i = 0; i < containerNode.getChildNodes().getLength(); ++i) {
            Node childNode = containerNode.getChildNodes().item(i);
            logger.info((Object)("Check child " + childNode));
            if (!(childNode instanceof Element)) continue;
            Element childElt = (Element)childNode;
            logger.info((Object)("  " + childElt.getTagName()));
            if (childElt.getTagName().equals("Placemark")) {
                this.parsePlacemark(childNode, out, cf, rf);
                continue;
            }
            if (!childElt.getTagName().equals("Folder")) continue;
            this.parseContainer(childNode, out, cf, rf);
        }
    }
}

