# -*- coding: utf-8 -*-
"""Module with built-in DSS color palettes"""


DSS_BUILTIN_COLOR_PALETTES = [
    {
        "id": "default",
        "name": "Default",
        "colors": ["#1F77B4", "#FF7F0E", "#2CA02C", "#D62728", "#9467BD", "#8C564B", "#E377C2", "#7F7F7F"],
    },
    {
        "id": "dku_dss_next",
        "name": "DSS Next",
        "colors": ["#00AEDB", "#8CC63F", "#FFC425", "#F37735", "#D11141", "#91268F", "#194BA3", "#00B159"],
    },
    {
        "id": "dku_pastel1",
        "name": "Pastel",
        "colors": ["#EC6547", "#FDC665", "#95C37B", "#75C2CC", "#694A82", "#538BC8", "#65B890", "#A874A0"],
    },
    {
        "id": "dku_corpo1",
        "name": "Corporate",
        "colors": ["#0075B2", "#818991", "#EA9423", "#A4C2DB", "#EF3C39", "#009D4B", "#CFD6D3", "#231F20"],
    },
    {
        "id": "dku_deuteranopia1",
        "name": "Deuteranopia",
        "colors": ["#193C81", "#7EA0F9", "#211924", "#757A8D", "#D6C222", "#776A37", "#AE963A", "#655E5D"],
    },
    {
        "id": "dku_tritanopia1",
        "name": "Tritanopia",
        "colors": ["#CA0849", "#0B4D61", "#E4B2BF", "#3F6279", "#F24576", "#7D8E98", "#9C4259", "#2B2A2E"],
    },
    {
        "id": "dku_pastel2",
        "name": "Pastel 2",
        "colors": ["#F06548", "#FDC766", "#7BC9A6", "#4EC5DA", "#548ECB", "#97668F", "#5E2974"],
    },
]
"""list: Constant with DSS built-in color palette identifiers, names and lists of colors

This is an amended version of what is in the DSS code base, without the faded colors and truncated to the first 8 colors
"""
