/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.numericbaseconversion;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class NumericBaseConversion
extends SingleInputSingleOutputRowProcessor
implements Processor {
    private static Pattern HEXADECIMAL_RE = Pattern.compile("(?:0[xX])?([0-9a-fA-F]+)[hH]?");
    private static Pattern BINARY_RE = Pattern.compile("([0-1]+)[bB]?");
    private static Pattern DECIMAL_RE = Pattern.compile("^([0-9]+)$");
    public static final ProcessorMeta<NumericBaseConversion, Parameter> META = new ProcessorMeta<NumericBaseConversion, Parameter>(){

        public String getName() {
            return "NumericBaseConversion";
        }

        public String getDocPage() {
            return "numeric-base-conversion";
        }

        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING, ProcessorTag.MATH});
        }

        public String getHelp() {
            return "This processor performs base conversion.\n \n# Input column\nContains the numbers to be converted\n \n# Conversion\nSelect the conversion mode to / from:\n* Decimal\n* Binary\n* Hexadecimal\n \n# Output column\nContains converted numbers";
        }

        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        public ProcessorDesc describe() {
            return ProcessorDesc.withGenericForm((String)this.getName(), (String)(1.actionVerb((String)"Convert") + " binary hexa to from decimal")).withMNEColParam("inputColumn", "Input column").withParam(ParamDesc.advancedSelect((String)"processingMode", (String)"Conversion", (String)"", ProcessingMode.class).withDefaultValue((Object)ProcessingMode.BINARY_TO_DECIMAL)).withColParam("outputColumn", "Output column");
        }

        public NumericBaseConversion build(Parameter parameter) throws Exception {
            return new NumericBaseConversion(parameter);
        }
    };
    private Parameter params;
    private Converter selectedConverter;
    private Column outputColumn;
    private Column cd;

    public NumericBaseConversion(Parameter params) {
        this.params = params;
    }

    public void processRow(Row row) throws Exception {
        String str = row.get(this.cd);
        if (str == null || str.equals("")) {
            this.getProcessorOutput().emitRow(row);
            return;
        }
        String output = this.selectedConverter.convert(str);
        if (output.length() != 0) {
            row.put(this.outputColumn, output);
        }
        this.getProcessorOutput().emitRow(row);
    }

    public void postProcess() throws Exception {
        this.getProcessorOutput().lastRowEmitted();
    }

    public void init() throws Exception {
        this.cd = this.getCf().column(this.params.inputColumn, Processor.ProcessorRole.INPUT_COLUMN);
        this.outputColumn = !StringUtils.isBlank((String)this.params.outputColumn) ? this.getCf().column(this.params.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN) : this.cd;
        this.selectedConverter = NumericBaseConversion.newConverter(this.params.processingMode);
    }

    @VisibleForTesting
    static Converter newConverter(ProcessingMode processingMode) {
        switch (processingMode) {
            case HEXA_TO_DECIMAL: {
                return new HexaToDecimal();
            }
            case BINARY_TO_DECIMAL: {
                return new BinaryToDecimal();
            }
            case DECIMAL_TO_HEXA: {
                return new DecimalToHexa();
            }
            case DECIMAL_TO_BINARY: {
                return new DecimalToBinary();
            }
            case HEXA_TO_BINARY: {
                return new HexaToBinary();
            }
            case BINARY_TO_HEXA: {
                return new BinaryToHexa();
            }
        }
        throw new IllegalArgumentException("Invalid processing mode: " + (Object)((Object)processingMode));
    }

    private static class BinaryToHexa
    extends Converter {
        private BinaryToHexa() {
        }

        @Override
        public String convert(String str) {
            return this.convert(str, 2, BINARY_RE, 16);
        }
    }

    private static class HexaToBinary
    extends Converter {
        private HexaToBinary() {
        }

        @Override
        public String convert(String str) {
            return this.convert(str, 16, HEXADECIMAL_RE, 2);
        }
    }

    private static class DecimalToHexa
    extends Converter {
        private DecimalToHexa() {
        }

        @Override
        public String convert(String str) {
            return this.convert(str, 10, DECIMAL_RE, 16);
        }
    }

    private static class DecimalToBinary
    extends Converter {
        private DecimalToBinary() {
        }

        @Override
        public String convert(String str) {
            return this.convert(str, 10, DECIMAL_RE, 2);
        }
    }

    private static class HexaToDecimal
    extends Converter {
        private HexaToDecimal() {
        }

        @Override
        public String convert(String str) {
            return this.convert(str, 16, HEXADECIMAL_RE, 10);
        }
    }

    private static class BinaryToDecimal
    extends Converter {
        private BinaryToDecimal() {
        }

        @Override
        public String convert(String str) {
            return this.convert(str, 2, BINARY_RE, 10);
        }
    }

    @VisibleForTesting
    static abstract class Converter {
        Converter() {
        }

        abstract String convert(String var1);

        String convert(String str, int sourceBase, Pattern sourceBaseRegexp, int destinationBase) {
            if (str == null) {
                throw new NullPointerException("str cannot be null");
            }
            Matcher matcher = sourceBaseRegexp.matcher(str);
            if (!matcher.matches()) {
                return "";
            }
            BigInteger input = new BigInteger(matcher.group(1), sourceBase);
            return input.toString(destinationBase).toUpperCase(Locale.ROOT);
        }
    }

    public static enum ProcessingMode implements Labelled
    {
        BINARY_TO_DECIMAL{

            public String getLabel() {
                return "Binary to Decimal";
            }
        }
        ,
        HEXA_TO_DECIMAL{

            public String getLabel() {
                return "Hexadecimal to Decimal";
            }
        }
        ,
        DECIMAL_TO_BINARY{

            public String getLabel() {
                return "Decimal to Binary";
            }
        }
        ,
        DECIMAL_TO_HEXA{

            public String getLabel() {
                return "Decimal to Hexadecimal";
            }
        }
        ,
        HEXA_TO_BINARY{

            public String getLabel() {
                return "Hexadecimal to Binary";
            }
        }
        ,
        BINARY_TO_HEXA{

            public String getLabel() {
                return "Binary to Hexadecimal";
            }
        };

    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inputColumn;
        public String outputColumn;
        public ProcessingMode processingMode;

        public void validate() throws IllegalArgumentException {
            NumericBaseConversion.newConverter(this.processingMode);
        }
    }
}

