package com.customllm.llm;

import java.io.IOException;
import java.util.List;
import com.dataiku.dip.llm.online.LLMClient.SimpleCompletionResponse;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMClient.ChatMessage;
import com.dataiku.common.rpc.ExternalJSONAPIClient;
import com.dataiku.dip.connections.AbstractLLMConnection.HTTPBasedLLMNetworkSettings;
import com.dataiku.dip.llm.online.LLMClient.StreamedCompletionResponseConsumer;

//Add in ToolChoice and Tools
interface CustomApiImplementation {
    public void addSettingsInObject(String model, Integer maxTokens, Double temperature, Double topP, Integer topK, List<String> stopSequences, LLMClient.ToolChoice toolChoice, List<LLMClient.AbstractTool> tools);
    public void addMessagesInObject(List<ChatMessage> messages);
    public SimpleCompletionResponse sendPostObject(ExternalJSONAPIClient client, HTTPBasedLLMNetworkSettings networkSettings) throws IOException;
    public void streamChatComplete(ExternalJSONAPIClient client, StreamedCompletionResponseConsumer consumer, HTTPBasedLLMNetworkSettings networkSettings, LLMClient.ToolChoice toolChoice, List<LLMClient.AbstractTool> tools) throws Exception;
}
