import dataiku
from osm_dataset_enrichment.dku_plugin_config_loading import DkuConfigLoadingOSM
from osm_dataset_enrichment.dataset_enrichment import OSMEnrichment
from osm_dataset_enrichment.utils.dku_utils import process_dataset_chunks


# load input parameters
dku_config = DkuConfigLoadingOSM()
settings = dku_config.load_settings()
polygon_dataframe = settings.polygon_dataset.get_dataframe(infer_with_pandas=False)
# run
osm_enrichment = OSMEnrichment(
    filters=settings.type_of_pois,
    enrichments=settings.enrichment_keys,
    request_by_batch=settings.request_by_batch,
)
process_dataset_chunks(
    input_dataset=settings.polygon_dataset,
    output_dataset=settings.pois_dataset,
    func=osm_enrichment.enrich_batch_df,
    polygon_column=settings.polygon_column,
    chunksize=100,
)
