var app = angular.module('osm.enrichment', []);

app.controller('MyCustomFormController', function ($scope, $timeout) {

    function updateCoordinates(minLat, minLon, maxLat, maxLon) {
        $scope.config.maxLat = maxLat;
        $scope.config.maxLon = maxLon;
        $scope.config.minLat = minLat;
        $scope.config.minLon = minLon;
        try {
            $scope.$apply();
        } catch (e) {
            console.error(e);
        }
    }

    let attempts = 0;
    function trySetup() {
        if (L.Control.Draw) {
            setupLeaflet(updateCoordinates)
        } else if (attempts++ < 100) {
            setTimeout(trySetup, 100);
        }
    }
    trySetup();
});

function setupLeaflet(updateCoordinates) {
    let map = L.map('osm-enrichment-map').setView([48.57, 2.35], 9);
    L.tileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy <a href="http://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap</a> contributors'
    }).addTo(map);
    let group = L.featureGroup().addTo(map);
    let drawCtrl = new L.Control.Draw({
        draw: {
            polygon: false,
            marker: false,
            circle: false,
            polyline: false,
            circlemarker: false,
        },
        edit: false
    });
    map.addControl(drawCtrl);
    map.on('draw:created', function (e) {
        try {
            group.clearLayers()
            group.addLayer(e.layer);
            let bbox = e.layer.getLatLngs();
            console.warn('bbox', bbox)
            let minLat = Math.min.call(null, bbox[0].lat, bbox[1].lat, bbox[2].lat, bbox[3].lat);
            let minLon = Math.min.call(null, bbox[0].lng, bbox[1].lng, bbox[2].lng, bbox[3].lng);
            let maxLat = Math.max.call(null, bbox[0].lat, bbox[1].lat, bbox[2].lat, bbox[3].lat);
            let maxLon = Math.max.call(null, bbox[0].lng, bbox[1].lng, bbox[2].lng, bbox[3].lng);
            updateCoordinates(minLat, minLon, maxLat, maxLon);
        } catch (e) {
            console.error(e);
        }
    });
}