from typing import AnyStr, List


def generate_unique(name: AnyStr, existing_names: List[AnyStr], prefix: AnyStr = None) -> AnyStr:
    """Generate a unique name among existing ones by suffixing a number and adding a prefix
    Args:
        name: Input name
        existing_names: List of existing names
        prefix: Optional prefix to add to the output name
    Returns:
       Unique name with a number suffix in case of conflict, and an optional prefix
    """
    if prefix:
        name_base = f"{prefix}_{name}"
    else:
        name_base = name
    if name_base not in existing_names:
        return name_base
    for j in range(1, 1001):
        new_name = f"{name_base}_{j}"
        if new_name not in existing_names:
            return new_name
    raise RuntimeError(f"Failed to generated a unique name for '{name}'")


def generate_unique_columns(df_columns: List[AnyStr], columns: List[AnyStr], prefix=None) -> List[AnyStr]:
    """Generate unique names for columns to add in a dataframe"""
    return [generate_unique(name=column, existing_names=df_columns, prefix=prefix) for column in columns]
