# -*- coding: utf-8 -*-
"""Module with read/write utility functions based on the Dataiku API"""

from typing import List, AnyStr

import dataiku


# ==============================================================================
# CLASS AND FUNCTION DEFINITION
# ==============================================================================


def generate_path_list(folder: dataiku.Folder) -> List[AnyStr]:
    path_list = []
    if folder.read_partitions:
        for partition in folder.read_partitions:
            path_list += folder.list_paths_in_partition(partition)
    else:
        path_list = folder.list_paths_in_partition()
    return path_list
