/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.formats.spss;

import com.dataiku.dss.formats.spss.SPSSStreamReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class SPSSInputStream
extends InputStream {
    Charset charset;
    DataInputStream is;
    boolean littleEndian;
    byte[] buff;

    SPSSInputStream(InputStream is) {
        this.is = new DataInputStream(is);
    }

    @Override
    public int read(byte[] userBuff) throws IOException {
        int ret = this.is.read(userBuff);
        this.buff = (byte[])userBuff.clone();
        if (ret < userBuff.length) {
            throw new EOFException("End of stream reached");
        }
        return ret;
    }

    @Override
    public int read() throws IOException {
        int ret = this.is.read();
        if (ret == -1) {
            throw new EOFException("End of stream reached");
        }
        return ret;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public int readInt() throws IOException {
        int i = this.is.readInt();
        if (this.littleEndian) {
            return Integer.reverseBytes(i);
        }
        return i;
    }

    public double readDouble() throws IOException {
        ByteBuffer bb;
        this.buff = new byte[8];
        this.is.read(this.buff);
        if (this.littleEndian) {
            bb = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).put(this.buff);
            bb.flip();
        } else {
            bb = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).put(this.buff);
        }
        return bb.getDouble();
    }

    public SPSSStreamReader.NumericFormat readNumericFormat() throws IOException {
        int formatCode = this.readInt();
        SPSSStreamReader.NumericFormat f = new SPSSStreamReader.NumericFormat();
        f.decimals = formatCode >> 0 & 0xFF;
        f.width = formatCode >> 8 & 0xFF;
        f.type = formatCode >> 16 & 0xFF;
        return f;
    }

    public String readString(int len, boolean shouldTrim) throws IOException {
        this.buff = new byte[len];
        this.is.read(this.buff);
        String ret = this.charset != null ? new String(this.buff, this.charset) : new String(this.buff);
        return shouldTrim ? ret.trim() : ret;
    }

    public List<Byte> getLastByteArray() {
        return Arrays.asList(ArrayUtils.toObject((byte[])this.buff));
    }

    public String readString(int len) throws IOException {
        return this.readString(len, true);
    }

    public void skipBytes(int i) throws IOException {
        if (this.buff.length + i == 8) {
            byte[] secondBuff = new byte[i];
            this.is.read(secondBuff);
            byte[] newBuff = new byte[8];
            System.arraycopy(this.buff, 0, newBuff, 0, this.buff.length);
            System.arraycopy(secondBuff, 0, newBuff, this.buff.length, secondBuff.length);
            this.buff = newBuff;
        } else {
            this.is.skipBytes(i);
        }
    }

    public byte[] toByteArray(double value) {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).order(this.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN).putDouble(value);
        return bytes;
    }
}

