import os
from datetime import datetime

import dataiku
from dataikuapi import DSSClient
from dataikuapi.dss.project import DSSProject
from utils.file_loader import get_object_from_json

GOLDEN_QUERIES_FILE_PATH = "./resources/golden_results.json"


class EvalFactory:
    def __init__(self):
        self.test_run_id = ""
        self.target_project_key = ""
        self.client: DSSClient = None
        self.project: DSSProject = None
        self.golden_queries = []

    def get_config(self):
        self.test_run_id = os.getenv("SQL_TOOL_EVAL_TEST_ID")
        self.target_project_key = os.getenv("SQL_TOOL_EVAL_TARGET_PROJECT_KEY")

        # golden queries
        self.golden_queries = get_object_from_json(GOLDEN_QUERIES_FILE_PATH)

        # target_project_key
        if not self.target_project_key:
            print(
                "\nNo project key defined (set `SQL_TOOL_EVAL_TARGET_PROJECT_KEY` environment variable to specify the project to use)"
            )
            raise Exception("No project key defined")

        self.client = dataiku.api_client()
        self.project = self.client.get_project(self.target_project_key)

        # test_run_id
        if not self.test_run_id:
            self.test_run_id = datetime.now().strftime("%Y%m%d_%H%M%S")
