import json
import logging
import re
from typing import Any, Dict


def try_parse_json(data: str) -> Any:
    try:
        return json.loads(data)
    except json.JSONDecodeError:
        return None

def extract_json(response_text: str) -> Dict[str, Any]:
    json_objects = re.findall(r'\{[\s\S]*\}', response_text)
    longest_json = max(json_objects, key=len, default="{}")
    json_data = try_parse_json(longest_json)
    if json_data is None:
        logging.exception("Error parsing json")
        json_data = try_parse_json(response_text)
    if json_data is None:
        raise ValueError(f"No valid JSON found in the response text: {response_text}")
    return json_data or {}