from typing import Any, Dict


class RunContext:
    """
    A class to store contextual data about the current execution of the SQL tool.

    Attributes:
        question (str): The question the tool is attempting to answer.
        sources (Dict[str, Any]): A dictionary containing metadata about the tool execution.
        trace (Dict[str, Any]): Trace generated from LLM calls.
    """

    def __init__(self, question, trace):
        self.question: str = question
        self.sources: Dict[str, Any] = {
            "toolCallDescription": f"sql-question-answering for question {question}",
            "items": [],
        }
        self.trace: Dict[str, Any] = trace
