import json


def get_object_from_json(file_path: str):
    try:
        with open(file_path, "r", encoding="utf-8") as file:
            data = json.load(file)

        return data

    except FileNotFoundError:
        raise Exception(f"Error: File '{file_path}' not found")
    except json.JSONDecodeError:
        raise Exception("Error: Invalid JSON format")
    except Exception as e:
        raise Exception(f"Error: {e}")
