import pandas as pd
import psycopg2
from resources.mini_dev_postgresql import QUERIES

"""
This script is useful if you want to regenerate the `eval-tool/resources/golden_results.json` file
based on the `eval-tool/resources/mini_dev_postgresql.py` list of SQL queries.

Please note that you will need to have a database populated with all the data from the `mini_dev` resources.
"""


def main() -> None:
    db_params = {
        "dbname": "bird_dev",
        "user": "dss",
        "password": "dss",
        "host": "localhost",
        "port": "5432",
    }

    conn = psycopg2.connect(**db_params)
    cursor = conn.cursor()
    results = []

    for query in QUERIES:
        result = {
            "query_id": query["question_id"],
            "db_id": query["db_id"],
            "golden_query": query["SQL"],
        }

        cursor.execute(query["SQL"])
        result["golden_results"] = cursor.fetchall()
        results.append(result)

    if results:
        df = pd.DataFrame(results)
        df.to_json("resources/golden_results.json", orient="records")


if __name__ == "__main__":
    main()
