def _find_decreasing_function(function, value):
    i, j = 0, len(function.x)
    # j is excluded
    while i < j:
        m = (i + j) // 2
        if function(function.x[m]) > value:
            i = m + 1
        else:
            j = m
    # if line does not got below given survival quantile
    # then return the last time
    if i == len(function.x):
        return function.x[i-1]
    return function.x[i]

def get_first_time_below_quantile(survival_function, survival_quantile):
    # get first time for wich survival_function(time) is equal or lower than the specified quantile
    time = _find_decreasing_function(survival_function, survival_quantile)
    return time
