from pandas.api.types import is_numeric_dtype

class BaseRecipe():

    NO_GROUP_NAME = "overall"
    GROUP_BY_COLUMN_NAME = "group_by"
    def __init__(self):
        pass

    def get_group_label(self, groupby_columns, groupby_values):
        # groupby_values can be of two different types depending on length of groupby_columns
        # if there is only 1 groupby column
        # --> groupby_values is just the value of that column name
        if len(groupby_columns) == 1:
            groupby_values_list = [groupby_values]
        # if there are more than 1 groupby columns
        # --> groupby_values is a tuple containing the values of the grouping columns in order of the columns
        else:
            groupby_values_list = list(groupby_values)

        # groupby_values_list is a list containing values of the grouping columns in order of the columns
        label = ' / '.join([a + " " + str(b) for a, b in list(zip(groupby_columns, groupby_values_list))])
        return label

    def check_duration_column(self, df, duration_column):
        if not is_numeric_dtype(df[duration_column]):
                raise ValueError(f'duration column {duration_column} should be of numeric type but is of type {self.input_df[self.duration_column].dtype}')

    def check_event_indicator_column(self, df, event_indicator_column):
        is_binary = df[event_indicator_column].isin([0, 1]).all()
        if not is_binary:
            raise ValueError("Event indicator values must be 0 or 1")
        
    def get_processed_data(self, df, event_indicator_column):
        """
        transform event indicator column from 1s and 0s to True and False
        """
        df[event_indicator_column] = [x == 1 for x in df[event_indicator_column]]
   