function drawChart(chart, data, config){

    data.sort(function(a,b){
    return a[config.timeline_column_name] - b[config.timeline_column_name];
    })
  
    const option = {
        color : [
        '#dd6b66',
        '#759aa0',
        '#e69d87',
        '#8dc1a9',
        '#ea7e53',
        '#eedd78',
        '#73a373',
        '#73b9bc',
        '#7289ab',
        '#91ca8c',
        '#f49f42'
        ],
        xAxis: {
        /*
        dirty hack: We use a time axis but provide number of days instead of timestamp
        The reason for this is that type:'value' with confidence
        intervals leads to bugs https://github.com/apache/echarts/issues/16744
        */

        type: 'time',
        axisLabel: {
            show: true,
            formatter: function(value) {
            return value.toString();
            }
        },
        axisTick: {
            length: 5,
            interval: 0
        },
        
        minorTick: {
            show: true,
            splitNumber: 5,
            length: 3
        }
        },
        
        tooltip: getTooltip(config),

        yAxis: {
        type: 'value',
        show: true,
        axisLabel:{
            formatter: function(value){
            return value.toFixed(2)
            }
        }
        },

        series: [],

        grid: {
        left: '5%',
        top: '5%',
        bottom: '5%',
        right: '20%'
        },
        
        legend: {
        //type: 'plain',
        orient: 'vertical',
        right: 0,
        top: 'center'
        }
  };
  
  
  const group_values = get_group_values(data, config)
  group_values.forEach(
    function(group_value){

      const survival_curve = getSurvivalCurve(data, config, group_value);
      option.series.push(survival_curve);

      if(config.show_confidence_intervals){
        const confidence_interval = getConfidenceIntervals(data, config, group_value);
        option.series.push(confidence_interval.lowerConfidence);
        option.series.push(confidence_interval.upperConfidence);
      }
      
      if(config.show_survival_line){
        const extended_data = get_extended_data(data, config, config.survival_probas_column_name, group_value)
        const vertical_quantile_line = getVerticalQuantileLine(extended_data, config, group_value)
        option.series.push(vertical_quantile_line)
      }

    } 
  );

  if(config.show_survival_line){
    option.series.push(getHorizontalSurvivalLine(config, data))
  }

    chart.setOption(option,true);
}
