
def do(payload, config, plugin_config, inputs):

    
    choices = None
    if config["model_type"] == "kaplan_meier":
        choices = [{
                "value": "survival_function",
                "label": "Survival function"
            },
            {
                "value": "cumulative_density",
                "label": "Cumulative density"
            }
        ]
    elif config["model_type"] == "weibull" or config["model_type"] == "piecewise_exponential":
        choices = [{
                "value": "survival_function",
                "label": "Survival function"
            },
            {
                "value": "cumulative_density",
                "label": "Cumulative density"
            },
            {
                "value": "density",
                "label": "Density"
            },
            {
                "value": "hazard",
                "label": "Hazard"
            },
            {
                "value": "cumulative_hazard",
                "label": "Cumulative hazard"
            }
        ]
    elif config["model_type"] == "nelson_aalen":
        choices = [{
                "value": "cumulative_hazard",
                "label": "Cumulative hazard"
            }
        ]
    else:
        raise Exception("model type not found when getting function types")
    
  
    return {"choices": choices}