# Survival Analysis Plugin
The Survival Analysis plugin allows users to implement survival analysis models within DSS such as Kaplan Meier, Weibull, Cox Proportional Hazards and XGBoost Accelerated Failure Time.
The plugin uses the [lifelines library](https://lifelines.readthedocs.io/en/latest/index.html) for all models except for XGBoost Accelerated Failure Time which uses the [XGBoost library](https://xgboost.readthedocs.io/en/stable/). 
Please note that this plugin is not supported and its accuracy is therefore not guaranteed.

# Components

The plugin contains the following components:
- Estimate survival probability recipe to fit univariate models such as Kaplan Meier, Weibull, Nelson Aalen and Piecewise Exponential
- Perform statistical tests recipe for standard survival analysis tests
- Confidence interval chart as a custom chart in the dropdown menu of charts to plot the output of univariate models
- Cox Proportional Hazards Regression algorithm inside the visual ML interface
- XGBoost Accelerated Failure Time algorithm inside the visual ML interface

# Release Notes
See the [changelog](CHANGELOG.md) for a history of notable changes to this plugin.

# License

This plugin is distributed under the [Apache License version 2.0](LICENSE).
