import dataiku
from dataiku.customrecipe import get_recipe_config, get_output_names_for_role
from recipes.io_utils import get_input_output
from recipes.recipe_config_loading import check_and_get_groupby_columns, check_duration_column_parameter, check_event_indicator_column_parameter, get_univariate_model_params
from recipes.univariate_model import UnivariateModel

# --- Setup
(input_dataset, output_dataset) = get_input_output()
recipe_config = get_recipe_config()
input_dataset_columns = [column["name"] for column in input_dataset.read_schema()]
check_duration_column_parameter(recipe_config, input_dataset_columns)
check_event_indicator_column_parameter(recipe_config, input_dataset_columns) # is it ok to pass input_dataset here?
groupby_columns = check_and_get_groupby_columns(recipe_config, input_dataset_columns)
duration_column = recipe_config.get('duration_column')
event_indicator_column = recipe_config.get('event_indicator_column')
params = get_univariate_model_params(recipe_config)

# --- Run
df = input_dataset.get_dataframe()
univariate_model = UnivariateModel(params)
output_df = univariate_model.get_output_df(df, duration_column, event_indicator_column, groupby_columns)

# --- Write output

#Trying to setup a descritption on a dataset to indicate people to use confidence interval charts

client = dataiku.api_client()
project = client.get_project(dataiku.default_project_key())
dataset_name_without_project_key = get_output_names_for_role('output_dataset')[0].split('.')[1]
dataset = project.get_dataset(dataset_name_without_project_key)
settings = dataset.get_settings()
settings.short_description = "Tip: Use the __confidence intervals chart in the dropdown menu of the charts tab__ to display this dataset"
settings.save()

survival_dataset = dataiku.Dataset(get_output_names_for_role('output_dataset')[0])
survival_dataset.write_with_schema(output_df)