from recipes.univariate_model import UnivariateModelParams


def get_univariate_model_params(recipe_config):
    def _p(param_name, default=None):
        return recipe_config.get(param_name, default)

    model_type = _p('model_type')
    function_to_output = _p('function_to_output')
    confidence_interval_percentage = _p('confidence_interval_percentage')
    breakpoints= _p('breakpoints')

    params = UnivariateModelParams(
        model_type=model_type,
        function_to_output=function_to_output,
        confidence_interval_percentage=confidence_interval_percentage,
        breakpoints=breakpoints)
    
    params.check()
    return params


def check_and_get_groupby_columns(recipe_config, dataset_columns):
    # COPIED and modified from time series plugin
    groupby_columns = recipe_config.get('groupby_columns')
    _check_groupby_columns(groupby_columns, dataset_columns)
    return groupby_columns
    
    
def _check_groupby_columns(groupby_columns, dataset_columns):
    if len(groupby_columns) >= 1 and not all(identifier in dataset_columns for identifier in groupby_columns):
        raise ValueError("Invalid groupby column names. Some column names do not belong to the dataset: {}".format(groupby_columns))
    
def check_duration_column_parameter(recipe_config, dataset_columns):
    if recipe_config.get("duration_column") not in dataset_columns:
        raise ValueError("Time column {} is not u column of the dataset. Please change its value to match the name of one of the dataset's columns".format(recipe_config.get("duration_column")))

def check_event_indicator_column_parameter(recipe_config, dataset_columns):
    if recipe_config.get("event_indicator_column") not in dataset_columns:
        raise ValueError("Event indicator column {} is not a column of the dataset. Please change its value to match the name of one of the dataset's columns".format(recipe_config.get("event_indicator_column")))
    