function getTooltip(config){
    const tooltip = {
        order: 'valueAsc',
        trigger: 'axis',
        confine: true,
        position: function(point){
        return [point[0]+50, point[1]]
        },
        formatter: function (params) {

            //this code is inspired from https://stackoverflow.com/questions/39714502/echarts3-baidu-colored-round-in-tooltip
            const colorSpan = color => '<span style="display:inline-block;margin-right:5px;border-radius:10px;width:9px;height:9px;background-color:' + color + '"></span>';
            let format = params[0].axisValue;

            // Deep copy of params
            const new_params = JSON.parse(JSON.stringify(params))

            let groups = {};
            for (const item of new_params) {
                // prevent push of survival line
                if (item.seriesName != survival_line_name){
                    if (!groups[item.seriesName]) {
                        groups[item.seriesName] = [];
                    }
                groups[item.seriesName].push(item);
                }
            }

            // create an array of format [[item_lower, item, item_upper], [...]]
            let result = Object.values(groups)

            // order groups by the descending order of survival probabilities (or more generally "function")
            result.sort(function(a,b){
                const a_function = a.find(item => item.seriesId.startsWith("function"))
                const b_function = b.find(item => item.seriesId.startsWith("function"))
                return b_function.data[1] - a_function.data[1]
            }
            )
            
            let new_result = []
            for (const group of result) {
                
                let group_function = group.find(item => item.seriesId.startsWith("function"))

                if (config.show_confidence_intervals) {
                    let group_lower = group.find(item => item.seriesId.startsWith("lower"))
                    let group_upper = group.find(item => item.seriesId.startsWith("upper"))
                    
                    // workaround to display upper confidence interval as its true value
                    // and not the difference upper - lower
                    group_upper.data[1] += group_lower.data[1];
                    var new_group = [group_upper, group_function, group_lower]
                    new_result.push(new_group)
                }
                else {
                    new_result.push(group_function)
                }
            }
            
            (new_result).forEach(item => {
                if(config.show_confidence_intervals){
                    var formatted_line = '</br>' + colorSpan(item[1].color) + ' ' + item[1].seriesName + ': ' + item[1].data[1].toFixed(2) + ' (' + item[2].data[1].toFixed(2) + ', ' + item[0].data[1].toFixed(2) + ')'
                }
                else{
                    var formatted_line = '</br>' + colorSpan(item.color) + ' ' + item.seriesName + ': ' + item.data[1].toFixed(2)
                }
                format += formatted_line;
            });

            return format;
        },
        axisPointer: {
            type: 'cross',
            animation: false,
            label: {
                formatter: function(params){  

                x = (params.value.toFixed(2)).toString()
                if (x.endsWith('.00')){
                    x = x.slice(0,-3)
                }
                return x
                },
                backgroundColor: '#ccc',
                borderColor: '#aaa',
                borderWidth: 1,
                shadowBlur: 0,
                shadowOffsetX: 0,
                shadowOffsetY: 0,
                color: '#222'
            }
        }
    }

  return tooltip
}